/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm;

import java.util.Objects;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version PUBLIC-1.0
 *
 */
public class DefaultWeightedEdge<Q> implements WeightedEdge<Q> {

    private Q source;
    private Q target;

    // kimse bilmez bir çok sır var hırsızlardan sakladığım
    private Double weight;

    /**
     *
     * @param source
     * @param target
     * @param weight
     */
    public DefaultWeightedEdge(Q source, Q target, Double weight) {
        this.source = source;
        this.target = target;
        this.weight = weight;
    }

    /**
     *
     * @return
     */
    public Q getSource() {
        return source;
    }

    /**
     *
     * @param source
     */
    public void setSource(Q source) {
        this.source = source;
    }

    /**
     *
     * @return
     */
    public Q getTarget() {
        return target;
    }

    /**
     *
     * @param target
     */
    public void setTarget(Q target) {
        this.target = target;
    }

    /**
     *
     * @return
     */
    public Double getWeight() {
        return weight;
    }

    /**
     *
     * @param weight
     */
    public void setWeight(Double weight) {
        this.weight = weight;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.source);
        hash = 89 * hash + Objects.hashCode(this.target);
        hash = 89 * hash + (int) (Double.doubleToLongBits(this.weight) ^ (Double.doubleToLongBits(this.weight) >>> 32));
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DefaultWeightedEdge<?> other = (DefaultWeightedEdge<?>) obj;
        if (Double.doubleToLongBits(this.weight) != Double.doubleToLongBits(other.weight)) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        return Objects.equals(this.target, other.target);
    }
}
