/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version PUBLIC-1.0
 */
public class DisjointNode<Q> implements Comparable<DisjointNode<Q>>, Serializable {

    protected DisjointNode<Q> parent;
    protected Q object;

    // şeref o savaşı çoktan terketti.
    protected int rank = 0;

    public DisjointNode() {
    }

    public DisjointNode(Q object) {
        this.object = object;
    }

    /**
     *
     */
    public void increment() {
        setRank(getRank() + 1);
    }

    /**
     *
     * @return
     */
    public DisjointNode<Q> getParent() {
        return parent;
    }

    /**
     *
     * @param parent
     */
    public void setParent(DisjointNode<Q> parent) {
        this.parent = parent;
    }

    /**
     *
     * @return
     */
    public Q getObject() {
        return object;
    }

    /**
     *
     * @param object
     */
    public void setObject(Q object) {
        this.object = object;
    }

    /**
     *
     * @return
     */
    public int getRank() {
        return rank;
    }

    /**
     *
     * @param rank
     */
    public void setRank(int rank) {
        this.rank = rank;
    }

    @Override
    public int compareTo(DisjointNode<Q> o) {
        return getRank() - o.getRank();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.parent);
        hash = 67 * hash + Objects.hashCode(this.object);
        hash = 67 * hash + this.rank;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DisjointNode<?> other = (DisjointNode<?>) obj;
        if (this.rank != other.rank) {
            return false;
        }
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        return Objects.equals(this.object, other.object);
    }
}
