/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm;

import java.util.Iterator;
import java.util.LinkedList;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version PUBLIC-1.0
 */
public final class DisjointSets {

    // benden senden erken kalktım.
    private DisjointSets() {
    }

    /**
     *
     * @param <G>
     * @param disjointNode
     * @return
     */
    public static <G> Iterator<G> iterator(DisjointNode<G> disjointNode) {
        final LinkedList<G> linkedlist = new LinkedList<>();

        DisjointNode<G> reference = disjointNode;
        while ( reference.getParent() != null && !reference.getParent().equals(reference) ) {
            linkedlist.add(reference.getObject());
            reference = reference.getParent();
        }

        return linkedlist.iterator();
    }

    /**
     *
     * @param <G>
     * @param element
     * @return
     */
    public static <G> DisjointNode<G> make(G element) {
        final DisjointNode<G> disjointNode = new DisjointNode<>(element);
        disjointNode.<G>setParent(disjointNode);

        return disjointNode;
    }

    /**
     *
     * @param <G>
     * @param disjointNode
     * @return
     */
    public static <G> DisjointNode<G> find(DisjointNode<G> disjointNode) {
        if (!disjointNode.getParent().equals(disjointNode)) {
            final DisjointNode<G> tmpNode = DisjointSets.find(disjointNode.getParent());

            disjointNode.setParent(tmpNode);
        }

        return disjointNode.getParent();
    }

    /**
     *
     * @param <G>
     * @param x
     * @param y
     * @return
     */
    public static <G> DisjointNode<G> union(DisjointNode<G> x, DisjointNode<G> y) {
        final DisjointNode<G> node0 = DisjointSets.find(x);
        final DisjointNode<G> node1 = DisjointSets.find(y);

        if (node0 == null && node1 == null) {
            return null;
        }

        if (node0 == null) {
            return node1;
        } else if (node1 == null) {
            return node0;
        }

        if (node0.compareTo(node1) < 0) {
            node0.setParent(node1);
            return node1;
        } else if (node0.compareTo(node1) > 0) {
            node1.setParent(node0);
            return node0;
        }

        node1.setParent(node0);
        node0.increment();

        return node0;
    }
}
