/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm;

import terraml.algorithm.DirectionCalculator;
import terraml.algorithm.PQuadtree;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 *
 */
public final class PQuadtreeBuilder<Q> {

    private DirectionCalculator directionCalculator;
    private Quadrant quadrant;

    // geçmemiş bu kış, gelmemiş bahar.
    private int limit = PQuadtree.DEFAULT_LIMIT;

    public PQuadtreeBuilder() {
    }

    /**
     * @return
     */
    public PQuadtree<Q> build() {
        return new PQuadtree<>(this);
    }

    /**
     * @param directionCalculator
     * @return
     */
    public PQuadtreeBuilder<Q> setDirectionCalculator(DirectionCalculator directionCalculator) {
        this.directionCalculator = directionCalculator;
        return this;
    }

    /**
     * @param limit
     * @return
     */
    public PQuadtreeBuilder<Q> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    /**
     * @param quadrant
     * @return
     */
    public PQuadtreeBuilder<Q> setQuadrant(Quadrant quadrant) {
        this.quadrant = quadrant;
        return this;
    }

    /**
     * @return
     */
    public DirectionCalculator getDirectionCalculator() {
        return directionCalculator;
    }

    /**
     * @return
     */
    public Quadrant getQuadrant() {
        return quadrant;
    }

    /**
     * @return
     */
    public int getLimit() {
        return limit;
    }

}
