/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version PUBLIC-1.0
 */
public interface WeightedEdge<Q> {

    /**
     *
     * @param <Q>
     * @param source
     * @param target
     * @param weight
     * @return
     */
    public static <Q> DefaultWeightedEdge<Q> create(Q source, Q target, Double weight) {
        return new DefaultWeightedEdge<>(source, target, weight);
    }

    /**
     *
     * @return
     */
    public Q getSource();

    /**
     *
     * @return
     */
    public Q getTarget();

    /**
     *
     * @return
     */
    public Object getWeight();
}
