/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm.iterator;

import java.util.Iterator;
import java.util.LinkedList;
import terraml.algorithm.node.AVLNode;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public class AVLOrderedTraversal<Q> implements Iterator<Q> {

    private final LinkedList<AVLNode<Q>> linkedList;

    private LinkedList<Q> temp;
    private boolean remained = false;

    /**
     * @param comp
     * @param root
     */
    public AVLOrderedTraversal(AVLNode<Q> root) {
        this.linkedList = new LinkedList<>();

        AVLNode<Q> instance = root;
        for ( AVLNode<Q> current = instance; current != null; current = current.getLeft() ) {
            this.linkedList.push(current);
        }
    }

    @Override
    public boolean hasNext() {
        return !linkedList.isEmpty();
    }

    @Override
    public Q next() {
        AVLNode<Q> current = linkedList.peek();

        if (temp != null && !temp.isEmpty()) {
            Q next = temp.pop();

            if (next != null) {
                return next;
            }
        }

        if (current.getDuplicates() != null && !current.getDuplicates().isEmpty()) {

            if (temp == null) {
                temp = new LinkedList<>();
            }

            for ( Q each : current.getDuplicates() ) {
                temp.add(each);
            }

        } else {
            linkedList.poll();
            for ( AVLNode<Q> child = current.getRight(); child != null; child = child.getLeft() ) {
                linkedList.push(child);
            }

            return current.getData();
        }

        linkedList.poll();

        return current.getData();
    }
}
