/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import terraml.algorithm.node.HashtableNode;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public class HashtableIterator<K, V> implements Iterator<List<V>> {

    private final List<HashtableNode<K, V>> table;
    private int current = 0;
    private int limit = 0;

    /**
     * @param hashtable
     */
    public HashtableIterator(HashtableNode<K, V>[] hashtable) {
        this.table = new ArrayList<>();

        for ( HashtableNode<K, V> each : hashtable ) {
            if (each != null) {
                table.add(each);
            }
        }

        this.limit = table.size();
    }

    @Override
    public boolean hasNext() {
        return current <= limit;
    }

    @Override
    public List<V> next() {
        return table.get(current++).getValues();
    }
}
