/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm.node;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 *
 */
public interface BiNode<Q> extends Comparator<Q>, Serializable {

    /**
     * @return
     */
    public Comparator<Q> getComparator();

    /**
     * @return
     */
    public BiNode<Q> getLeft();

    /**
     * @param left
     */
    public void setLeft(BiNode<Q> left);

    /**
     * @return
     */
    public BiNode<Q> getRight();

    /**
     * @param right
     */
    public void setRight(BiNode<Q> right);

    /**
     * @return
     */
    public Q getData();

    /**
     * @param data
     */
    public void setData(Q data);

    /**
     * @return
     */
    public List<Q> getDuplicates();

    /**
     * @param duplicates
     */
    public void setDuplicates(List<Q> duplicates);

    /**
     * @param data
     * @return
     */
    public boolean addDuplicate(Q data);

    @Override
    public int compare(Q object0, Q object1);

}
