/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm.node;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public class BiSearchNode<Q> implements BiNode<Q> {

    private final Comparator<Q> comparator;

    private BiNode<Q> left;
    private BiNode<Q> right;
    private int height;
    private Q data;
    private List<Q> duplicates;

    public BiSearchNode(Comparator<Q> comp) {
        this.comparator = comp;
        this.left = null;
        this.right = null;
        this.height = 0;
        this.data = null;
        this.duplicates = null;
    }

    /**
     *
     * @param data
     */
    public BiSearchNode(Comparator<Q> comp, Q data) {
        this(comp);
        this.data = data;
    }

    @Override
    public int compare(Q object0, Q object1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /**
     * <p>
     * Method safely adds given element to duplicates.
     * </p>
     *
     * @param src source
     * @return true if adding duplicate element to list was succeed.
     *         Otherwise it returns false.
     */
    public boolean addDuplicate(Q src) {
        if (src == null) {
            return false;
        }

        if (getDuplicates() == null) {
            this.duplicates = new ArrayList<>();
        }

        return getDuplicates().add(src);
    }

    /**
     * @return
     */
    public BiNode<Q> getRight() {
        return right;
    }

    /**
     * @param right
     */
    public void setRight(BiNode<Q> right) {
        this.right = right;
    }

    /**
     * @return
     */
    public BiNode<Q> getLeft() {
        return left;
    }

    /**
     * @param left
     */
    public void setLeft(BiNode<Q> left) {
        this.left = left;
    }

    /**
     *
     * @return
     */
    public int getHeight() {
        return height;
    }

    /**
     *
     * @param height
     */
    public void setHeight(int height) {
        this.height = height;
    }

    /**
     * @return
     */
    public Q getData() {
        return data;
    }

    /**
     * @param data
     */
    public void setData(Q data) {
        this.data = data;
    }

    /**
     * @return
     */
    public List<Q> getDuplicates() {
        return duplicates;
    }

    /**
     * @param duplicates
     */
    public void setDuplicates(List<Q> duplicates) {
        this.duplicates = duplicates;
    }

    /**
     * @return
     */
    public Comparator<Q> getComparator() {
        return comparator;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.left);
        hash = 59 * hash + Objects.hashCode(this.right);
        hash = 59 * hash + this.height;
        hash = 59 * hash + Objects.hashCode(this.data);
        hash = 59 * hash + Objects.hashCode(this.duplicates);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final BiSearchNode<?> other = (BiSearchNode<?>) obj;
        if (this.height != other.height) {
            return false;
        }
        if (!Objects.equals(this.left, other.left)) {
            return false;
        }
        if (!Objects.equals(this.right, other.right)) {
            return false;
        }
        if (!Objects.equals(this.data, other.data)) {
            return false;
        }
        if (!Objects.equals(this.duplicates, other.duplicates)) {
            return false;
        }
        return true;
    }
}
