/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-algorithm project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.algorithm.node;

import java.io.Serializable;
import java.util.Objects;
import terraml.algorithm.GeoPoint;
import static terraml.commons.Objects.isNull;

/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public class KDNode2 implements Serializable {

    private KDNode2 left = null;
    private KDNode2 right = null;
    private KDNode2 parent = null;

    private GeoPoint coordinate;
    private int height = 0;

    /**
     * @param object
     * @param height
     */
    public KDNode2(GeoPoint object, int height) {
        this.coordinate = object;
        this.height = height;
    }

    /**
     * @param object
     */
    public KDNode2(GeoPoint object) {
        this.coordinate = object;
    }

    /**
     * @return
     */
    public boolean isLeftEmpty() {
        return isNull(left);
    }

    /**
     * @return
     */
    public boolean isRightEmpty() {
        return isNull(right);
    }

    /**
     * @return
     */
    public boolean isParentEmpty() {
        return isNull(parent);
    }

    /**
     * @return
     */
    public boolean isLeaf() {
        return isLeftEmpty() && isRightEmpty();
    }

    /**
     * @return
     */
    public KDNode2 getLeft() {
        return left;
    }

    /**
     * @param left
     */
    public void setLeft(KDNode2 left) {
        this.left = left;
    }

    /**
     * @return
     */
    public KDNode2 getRight() {
        return right;
    }

    /**
     * @param right
     */
    public void setRight(KDNode2 right) {
        this.right = right;
    }

    /**
     * @return
     */
    public KDNode2 getParent() {
        return parent;
    }

    /**
     * @param parent
     */
    public void setParent(KDNode2 parent) {
        this.parent = parent;
    }

    /**
     * @return
     */
    public GeoPoint getCoordinate() {
        return coordinate;
    }

    /**
     * @param coordinate
     */
    public void setCoordinate(GeoPoint coordinate) {
        this.coordinate = coordinate;
    }

    /**
     * @return
     */
    public int getHeight() {
        return height;
    }

    /**
     * @param height
     */
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.left);
        hash = 37 * hash + Objects.hashCode(this.right);
        hash = 37 * hash + Objects.hashCode(this.parent);
        hash = 37 * hash + Objects.hashCode(this.coordinate);
        hash = 37 * hash + this.height;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final KDNode2 other = (KDNode2) obj;
        if (this.height != other.height) {
            return false;
        }
        if (!Objects.equals(this.left, other.left)) {
            return false;
        }
        if (!Objects.equals(this.right, other.right)) {
            return false;
        }
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (!Objects.equals(this.coordinate, other.coordinate)) {
            return false;
        }
        return true;
    }
}
