/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import terraml.algorithm.AStarGraph;
import terraml.algorithm.node.AStarNode;

public class AStar<Q> {
    private final AStarGraph<Q> graph;

    public AStar(AStarGraph<Q> graphAStar) {
        this.graph = graphAStar;
    }

    public List<Q> astar(Q source, Q destination) {
        PriorityQueue<AStarNode<Q>> openQueue = new PriorityQueue<AStarNode<Q>>(11, new NodeComparator());
        AStarNode<Q> sourceNodeData = this.graph.getNodeData(source);
        sourceNodeData.setDistanceFromSource(0.0);
        sourceNodeData.calcF(destination);
        openQueue.add(sourceNodeData);
        HashMap path = new HashMap();
        HashSet<AStarNode> closedList = new HashSet<AStarNode>();
        while (!openQueue.isEmpty()) {
            AStarNode nodeData = (AStarNode)openQueue.poll();
            if (nodeData.getId().equals(destination)) {
                return this.path(path, destination);
            }
            closedList.add(nodeData);
            for (Map.Entry<AStarNode<Q>, Double> neighborEntry : this.graph.edgesFrom(nodeData.getId()).entrySet()) {
                double distanceBetweenTwoNodes;
                double tentativeG;
                AStarNode<Q> neighbor = neighborEntry.getKey();
                if (closedList.contains(neighbor) || !((tentativeG = (distanceBetweenTwoNodes = neighborEntry.getValue().doubleValue()) + nodeData.getDistanceFromSource()) < neighbor.getDistanceFromSource())) continue;
                neighbor.setDistanceFromSource(tentativeG);
                neighbor.calcF(destination);
                path.put(neighbor.getId(), nodeData.getId());
                if (openQueue.contains(neighbor)) continue;
                openQueue.add(neighbor);
            }
        }
        return null;
    }

    private List<Q> path(Map<Q, Q> path, Q destination) {
        assert (path != null);
        assert (destination != null);
        ArrayList<Q> pathList = new ArrayList<Q>();
        pathList.add(destination);
        while (path.containsKey(destination)) {
            destination = path.get(destination);
            pathList.add(destination);
        }
        Collections.reverse(pathList);
        return pathList;
    }

    public class NodeComparator
    implements Comparator<AStarNode<Q>> {
        @Override
        public int compare(AStarNode<Q> nodeFirst, AStarNode<Q> nodeSecond) {
            if (nodeFirst.getCost() > nodeSecond.getCost()) {
                return 1;
            }
            if (nodeSecond.getCost() > nodeFirst.getCost()) {
                return -1;
            }
            return 0;
        }
    }
}

