/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import terraml.algorithm.node.AStarNode;

public class AStarGraph<Q>
implements Iterable<Q> {
    private final Map<Q, Map<AStarNode<Q>, Double>> graph;
    private final Map<Q, Map<Q, Double>> heuristicMap;
    private final Map<Q, AStarNode<Q>> collector;

    public AStarGraph(Map<Q, Map<Q, Double>> heuristicMap) {
        if (heuristicMap == null) {
            throw new NullPointerException("The huerisic map should not be null");
        }
        this.graph = new HashMap<Q, Map<AStarNode<Q>, Double>>();
        this.collector = new HashMap<Q, AStarNode<Q>>();
        this.heuristicMap = heuristicMap;
    }

    public void addNode(Q id) {
        if (id == null) {
            throw new NullPointerException("The node cannot be null");
        }
        if (!this.heuristicMap.containsKey(id)) {
            throw new NoSuchElementException("This node is not a part of hueristic map");
        }
        this.graph.put(id, new HashMap());
        this.collector.put(id, new AStarNode<Q>(id, this.heuristicMap.get(id)));
    }

    public void addEdge(Q nodeIdFirst, Q nodeIdSecond, double length) {
        if (nodeIdFirst == null || nodeIdSecond == null) {
            throw new NullPointerException("The first nor second node can be null.");
        }
        if (!this.heuristicMap.containsKey(nodeIdFirst) || !this.heuristicMap.containsKey(nodeIdSecond)) {
            throw new NoSuchElementException("Source and Destination both should be part of the part of hueristic map");
        }
        if (!this.graph.containsKey(nodeIdFirst) || !this.graph.containsKey(nodeIdSecond)) {
            throw new NoSuchElementException("Source and Destination both should be part of the part of graph");
        }
        this.graph.get(nodeIdFirst).put(this.collector.get(nodeIdSecond), length);
        this.graph.get(nodeIdSecond).put(this.collector.get(nodeIdFirst), length);
    }

    public Map<AStarNode<Q>, Double> edgesFrom(Q id) {
        if (id == null) {
            throw new NullPointerException("The input node should not be null.");
        }
        if (!this.heuristicMap.containsKey(id)) {
            throw new NoSuchElementException("This node is not a part of hueristic map");
        }
        if (!this.graph.containsKey(id)) {
            throw new NoSuchElementException("The node should not be null.");
        }
        return Collections.unmodifiableMap(this.graph.get(id));
    }

    public AStarNode<Q> getNodeData(Q id) {
        if (id == null) {
            throw new NullPointerException("The nodeid should not be empty");
        }
        if (!this.collector.containsKey(id)) {
            throw new NoSuchElementException("The nodeId does not exist");
        }
        return this.collector.get(id);
    }

    @Override
    public Iterator<Q> iterator() {
        return this.graph.keySet().iterator();
    }
}

