/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import terraml.algorithm.BiTreeSet;
import terraml.algorithm.iterator.BiOrderedTraversal;
import terraml.algorithm.node.BiNode;
import terraml.algorithm.node.BiSearchNode;
import terraml.commons.Objects;

public class BiSearch<Q>
implements BiTreeSet<Q>,
Serializable {
    private static final long serialVersionUID = 9273273515765231L;
    private final Comparator<Q> comparator;
    private BiNode<Q> root;

    public BiSearch(Comparator<Q> comp, Q item) {
        this.comparator = comp;
        this.root = new BiSearchNode<Q>(this.comparator, item);
    }

    public BiSearch(Comparator<Q> comparator, BiNode<Q> root) {
        this.comparator = comparator;
        this.root = root;
    }

    protected boolean hasDuplicates(BiNode<Q> src) {
        return src != null && src.getDuplicates() != null;
    }

    protected boolean eq(Q data, BiNode<Q> src) {
        return data != null && src != null && this.comparator.compare(data, src.getData()) == 0;
    }

    protected boolean st(Q data, BiNode<Q> src) {
        return data != null && src != null && this.comparator.compare(data, src.getData()) < 0;
    }

    protected boolean gt(Q data, BiNode<Q> src) {
        return data != null && src != null && this.comparator.compare(data, src.getData()) > 0;
    }

    protected boolean btw(Q from, Q to, BiNode<Q> src) {
        if (Objects.isNull(from) || Objects.isNull(to) || Objects.isNull(src)) {
            return false;
        }
        return this.st(from, src) && this.gt(to, src);
    }

    protected boolean le(BiNode<Q> src) {
        return src != null && src.getLeft() == null;
    }

    protected boolean re(BiNode<Q> src) {
        return src != null && src.getRight() == null;
    }

    protected boolean lf(BiNode<Q> src) {
        return src != null && src.getLeft() == null && src.getRight() == null;
    }

    protected int size(BiNode<Q> src) {
        if (src == null) {
            return 0;
        }
        int count = 1;
        if (this.hasDuplicates(src)) {
            count += src.getDuplicates().size();
        }
        return count + this.size(src.getLeft()) + this.size(src.getRight());
    }

    protected int familySize(BiNode<Q> src) {
        if (src == null) {
            return 0;
        }
        return 1 + this.familySize(src.getLeft()) + this.familySize(src.getRight());
    }

    protected int height(BiNode<Q> src) {
        if (src == null) {
            return 0;
        }
        return 1 + Math.max(this.height(src.getLeft()), this.height(src.getRight()));
    }

    protected Q minimum(BiNode<Q> src) {
        if (this.le(src)) {
            return src.getData();
        }
        return this.minimum(src.getLeft());
    }

    protected Q maximum(BiNode<Q> src) {
        if (this.re(src)) {
            return src.getData();
        }
        return this.maximum(src.getRight());
    }

    protected BiNode<Q> minimumFamily(BiNode<Q> src) {
        if (this.le(src)) {
            return src;
        }
        return this.minimumFamily(src.getLeft());
    }

    protected BiNode<Q> maximumFamily(BiNode<Q> src) {
        if (this.re(src)) {
            return src;
        }
        return this.maximumFamily(src.getRight());
    }

    protected BiNode<Q> add(BiNode<Q> src, Q item) {
        if (src == null) {
            return new BiSearchNode<Q>(this.comparator, item);
        }
        if (this.eq(item, src)) {
            src.addDuplicate(item);
            return src;
        }
        if (this.st(item, src)) {
            src.setLeft(this.add(src.getLeft(), item));
        } else if (this.gt(item, src)) {
            src.setRight(this.add(src.getRight(), item));
        }
        return src;
    }

    @Override
    public boolean add(Q item) {
        BiNode<Q> subRoot = this.add(this.getRoot(), item);
        if (subRoot != null) {
            this.setRoot(subRoot);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Q> collection) {
        boolean isOk = true;
        for (Q each : collection) {
            if (this.add(each)) continue;
            isOk = false;
            break;
        }
        return isOk;
    }

    protected BiNode<Q> removeFamily(BiNode<Q> src, Q item) {
        if (this.eq(item, src)) {
            if (this.lf(src)) {
                return null;
            }
            if (this.le(src)) {
                return src.getRight();
            }
            if (this.re(src)) {
                return src.getLeft();
            }
            BiNode<Q> edge = src.getRight();
            BiNode<Q> current = src.getRight();
            while (!this.le(edge)) {
                edge = edge.getLeft();
            }
            edge.setLeft(src.getLeft());
            return current;
        }
        if (this.st(item, src)) {
            src.setLeft(this.removeFamily(src.getLeft(), item));
        } else if (this.gt(item, src)) {
            src.setRight(this.removeFamily(src.getRight(), item));
        }
        return src;
    }

    @Override
    public void removeFamily(Q item) {
        BiNode<Q> tmpFamily = this.removeFamily(this.getRoot(), item);
        if (tmpFamily != null) {
            this.setRoot(tmpFamily);
        }
    }

    @Override
    public void removeAllFamily(Collection<? extends Q> collection) {
        collection.forEach(this::removeFamily);
    }

    @Override
    public boolean remove(Object item) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected BiNode<Q> getFamily(BiNode<Q> src, Q item) {
        if (src == null) {
            return null;
        }
        if (this.st(item, src)) {
            src = this.getFamily(src.getLeft(), item);
        } else if (this.gt(item, src)) {
            src = this.getFamily(src.getRight(), item);
        }
        return this.eq(item, src) ? src : null;
    }

    @Override
    public boolean containsFamily(Q item) {
        return this.getFamily(this.getRoot(), item) != null;
    }

    @Override
    public boolean containsAllFamily(Collection<Q> collection) {
        for (Q each : collection) {
            if (this.containsFamily(each)) continue;
            return false;
        }
        return true;
    }

    protected BiNode<Q> get(BiNode<Q> src, Q item) {
        if (src == null) {
            return null;
        }
        if (this.st(item, src)) {
            src = this.get(src.getLeft(), item);
        } else if (this.gt(item, src)) {
            src = this.get(src.getRight(), item);
        }
        if (this.eq(item, src)) {
            if (item.equals(src.getData())) {
                return src;
            }
            if (this.hasDuplicates(src)) {
                for (Q each : src.getDuplicates()) {
                    if (!item.equals(each)) continue;
                    return src;
                }
            }
        }
        return null;
    }

    @Override
    public boolean contains(Object item) {
        return this.get(this.getRoot(), item) != null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object each : collection) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.size(this.getRoot());
    }

    @Override
    public Iterator<Q> lastFamily() {
        BiNode<Q> bi = this.minimumFamily(this.getRoot());
        ArrayList<Q> list = new ArrayList<Q>();
        list.add(bi.getData());
        if (this.hasDuplicates(bi)) {
            for (Q each : bi.getDuplicates()) {
                list.add(each);
            }
        }
        return list.iterator();
    }

    @Override
    public Iterator<Q> firstFamily() {
        BiNode<Q> bi = this.maximumFamily(this.getRoot());
        ArrayList<Q> list = new ArrayList<Q>();
        list.add(bi.getData());
        if (this.hasDuplicates(bi)) {
            for (Q each : bi.getDuplicates()) {
                list.add(each);
            }
        }
        return list.iterator();
    }

    @Override
    public Q last() {
        return this.maximum(this.getRoot());
    }

    @Override
    public Q first() {
        return this.minimum(this.getRoot());
    }

    protected List<Q> collect(BiNode<Q> src, List<Q> list) {
        if (src == null) {
            return list;
        }
        list.add(src.getData());
        if (this.hasDuplicates(src)) {
            for (Q each : src.getDuplicates()) {
                list.add(each);
            }
        }
        list = this.collect(src.getLeft(), list);
        list = this.collect(src.getRight(), list);
        return list;
    }

    @Override
    public Iterator<Q> iterator() {
        return new BiOrderedTraversal<Q>(this.getRoot());
    }

    @Override
    public Stream<Q> stream() {
        return this.collect(this.root, new ArrayList()).stream();
    }

    public BiNode<Q> getRoot() {
        return this.root;
    }

    public void setRoot(BiNode<Q> obj) {
        this.root = obj;
    }

    @Override
    public Spliterator<Q> spliterator() {
        return this.collect(this.root, new ArrayList()).spliterator();
    }

    protected BiNode<Q> tailSet(BiNode<Q> src, Q item) {
        if (src == null) {
            return null;
        }
        while ((this.eq(item, src) || this.gt(item, src)) && src != null) {
            src = this.tailSet(src.getRight(), item);
        }
        if (this.st(item, src)) {
            src.setLeft(this.tailSet(src.getLeft(), item));
        }
        return src;
    }

    @Override
    public BiTreeSet<Q> tailSet(Q fromElement) {
        BiNode<Q> bi = this.getRoot();
        bi = this.tailSet(bi, fromElement);
        return new BiSearch<Q>(this.comparator, bi);
    }

    protected BiNode<Q> headSet(BiNode<Q> src, Q item) {
        if (src == null) {
            return null;
        }
        while ((this.eq(item, src) || this.st(item, src)) && src != null) {
            src = this.headSet(src.getLeft(), item);
        }
        if (this.gt(item, src)) {
            src.setRight(this.headSet(src.getRight(), item));
        }
        return src;
    }

    @Override
    public BiTreeSet<Q> headSet(Q toElement) {
        BiNode<Q> bi = this.getRoot();
        bi = this.headSet(bi, toElement);
        return new BiSearch<Q>(this.comparator, bi);
    }

    protected BiNode<Q> subSet(BiNode<Q> src, Q from, Q to) {
        if (src == null) {
            return null;
        }
        if (this.st(to, src)) {
            return this.subSet(src.getLeft(), from, to);
        }
        if (this.gt(from, src)) {
            return this.subSet(src.getRight(), from, to);
        }
        src.setLeft(this.subSet(src.getLeft(), from, to));
        src.setRight(this.subSet(src.getRight(), from, to));
        return src;
    }

    @Override
    public BiTreeSet<Q> subSet(Q fromElement, Q toElement) {
        BiNode<Q> bi = this.getRoot();
        bi = this.subSet(bi, fromElement, toElement);
        return new BiSearch<Q>(this.comparator, bi);
    }

    @Override
    public Comparator<? super Q> comparator() {
        return this.comparator;
    }

    @Override
    public void clear() {
        this.setRoot(null);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collect(this.root, new ArrayList()).toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.collect(this.root, new ArrayList()).toArray();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Stream<Q> parallelStream() {
        return this.collect(this.root, new ArrayList()).parallelStream();
    }

    @Override
    public boolean removeIf(Predicate<? super Q> filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void forEach(Consumer<? super Q> action) {
        this.stream().forEach(action);
    }
}

