/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.Objects;
import terraml.algorithm.WeightedEdge;

public class DefaultWeightedEdge<Q>
implements WeightedEdge<Q> {
    private Q source;
    private Q target;
    private Double weight;

    public DefaultWeightedEdge(Q source, Q target, Double weight) {
        this.source = source;
        this.target = target;
        this.weight = weight;
    }

    @Override
    public Q getSource() {
        return this.source;
    }

    public void setSource(Q source) {
        this.source = source;
    }

    @Override
    public Q getTarget() {
        return this.target;
    }

    public void setTarget(Q target) {
        this.target = target;
    }

    @Override
    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.source);
        hash = 89 * hash + Objects.hashCode(this.target);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.weight) ^ Double.doubleToLongBits(this.weight) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultWeightedEdge other = (DefaultWeightedEdge)obj;
        if (Double.doubleToLongBits(this.weight) != Double.doubleToLongBits(other.weight)) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        return Objects.equals(this.target, other.target);
    }
}

