/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import terraml.algorithm.GeoPoint;
import terraml.commons.math.Angle;
import terraml.commons.unit.DirectionUnit;

@FunctionalInterface
public interface DirectionCalculator {
    public DirectionUnit of(GeoPoint var1, GeoPoint var2);

    default public DirectionUnit of(double fromX0, double fromY0, double toX0, double toY0) {
        return this.of(new GeoPoint(fromX0, fromY0), new GeoPoint(toX0, toY0));
    }

    default public double azimuth(GeoPoint from, GeoPoint to) {
        double lat0 = Math.toRadians(from.getX());
        double lon0 = Math.toRadians(from.getY());
        double lat1 = Math.toRadians(to.getX());
        double lon1 = Math.toRadians(to.getY());
        double _lat0 = lat0;
        double _lat1 = lat1;
        double _dlon = lon1 - lon0;
        double _letY = Math.sin(_dlon) * Math.cos(_lat1);
        double _letX = Math.cos(_lat0) * Math.sin(_lat1) - Math.sin(_lat0) * Math.cos(_lat1) * Math.cos(_dlon);
        double initBearing = Math.toDegrees(Math.atan2(_letY, _letX));
        double Q = (360.0 + initBearing) % 360.0;
        return Angle.fromDegree((double)Q).degree;
    }

    default public DirectionUnit fromAzimuth(GeoPoint from, GeoPoint to) {
        double bearing = this.azimuth(from, to);
        if (bearing >= 0.0 && bearing <= 90.0) {
            return DirectionUnit.NORTH_EAST;
        }
        if (bearing >= 90.0 && bearing <= 180.0) {
            return DirectionUnit.SOUTH_EAST;
        }
        if (bearing >= 180.0 && bearing <= 270.0) {
            return DirectionUnit.SOUTH_WEST;
        }
        if (bearing >= 270.0 && bearing <= 360.0) {
            return DirectionUnit.NORTH_WEST;
        }
        return null;
    }
}

