/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import terraml.algorithm.DefaultWeightedEdge;

public class FloydWarshall<Q> {
    private final State<Q> state;
    private final double[][] costMatrix;

    public FloydWarshall(State<Q> state) {
        this.state = state;
        this.costMatrix = this.createCostMatrix(this.state);
    }

    public static <W> FloydWarshall<W> create(Collection<DefaultWeightedEdge<W>> collection) {
        return new FloydWarshall<W>(FloydWarshall.init(collection));
    }

    public void execute() {
        int len = this.costMatrix.length;
        for (int k = 0; k < len; ++k) {
            for (int i = 0; i < len; ++i) {
                for (int j = 0; j < len; ++j) {
                    if (!(this.costMatrix[i][k] + this.costMatrix[k][j] < this.costMatrix[i][j])) continue;
                    this.costMatrix[i][j] = this.costMatrix[i][k] + this.costMatrix[k][j];
                }
            }
        }
    }

    public List<DefaultWeightedEdge<Q>> toList() {
        ArrayList<DefaultWeightedEdge<Q>> list = new ArrayList<DefaultWeightedEdge<Q>>();
        for (List current : this.state.graph.values()) {
            boolean isEmpty;
            if (current == null || (isEmpty = current.isEmpty())) continue;
            list.addAll(current);
        }
        return list;
    }

    public double get(Q from, Q to) {
        int row = this.state.index.get(from);
        int column = this.state.index.get(to);
        return this.get(row, column);
    }

    public double get(int row, int column) {
        return this.costMatrix[row][column];
    }

    private double[][] createCostMatrix(State<Q> givenState) {
        int i;
        int len = givenState.uniqueIdCount;
        double[][] matrix = new double[len][len];
        int indexerSize = givenState.index.size();
        for (i = 0; i < indexerSize; ++i) {
            for (int j = 0; j < indexerSize; ++j) {
                matrix[i][j] = Double.NaN;
            }
        }
        for (i = 0; i < indexerSize; ++i) {
            Q current = this.findData(i);
            List tmp = givenState.graph.get(current);
            for (DefaultWeightedEdge edge : tmp) {
                int row = givenState.index.get(edge.getSource());
                int column = givenState.index.get(edge.getTarget());
                matrix[row][column] = edge.getWeight();
            }
        }
        return matrix;
    }

    public Q findData(Integer index) {
        for (Map.Entry entry : this.state.index.entrySet()) {
            if (!Objects.equals(index, entry.getValue())) continue;
            return (Q)entry.getKey();
        }
        return null;
    }

    private static <W> State<W> init(Collection<DefaultWeightedEdge<W>> collection) {
        HashMap newGraph = new HashMap();
        HashMap<W, Integer> indexer = new HashMap<W, Integer>();
        HashSet<W> pointers = new HashSet<W>();
        int index = 0;
        for (DefaultWeightedEdge<W> currentEdge : collection) {
            if (!pointers.contains(currentEdge.getSource())) {
                pointers.add(currentEdge.getSource());
            }
            if (!pointers.contains(currentEdge.getTarget())) {
                pointers.add(currentEdge.getTarget());
            }
            W source = currentEdge.getSource();
            W target = currentEdge.getTarget();
            if (newGraph.get(source) == null) {
                ArrayList<DefaultWeightedEdge<W>> tmp = new ArrayList<DefaultWeightedEdge<W>>();
                tmp.add(currentEdge);
                newGraph.put(source, tmp);
                indexer.put(source, index);
                ++index;
            } else if (!((List)newGraph.get(source)).contains(currentEdge)) {
                ((List)newGraph.get(source)).add(currentEdge);
            }
            if (newGraph.get(target) != null) continue;
            newGraph.put(target, new ArrayList());
            indexer.put(target, index);
            ++index;
        }
        return new State(newGraph, indexer, pointers.size());
    }

    public double[][] getCostMatrix() {
        return this.costMatrix;
    }

    public State<Q> getState() {
        return this.state;
    }

    public static class State<W> {
        public final HashMap<W, List<DefaultWeightedEdge<W>>> graph;
        public final HashMap<W, Integer> index;
        public final int uniqueIdCount;

        public State(HashMap<W, List<DefaultWeightedEdge<W>>> graph, HashMap<W, Integer> index, int pointer) {
            this.graph = graph;
            this.index = index;
            this.uniqueIdCount = pointer;
        }
    }
}

