/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import terraml.algorithm.node.HashtableNode;

public class Hashtable<K, V> {
    private int node_count;
    private int total_count;
    private HashtableNode<K, V>[] hashtable;
    private static final int INITIAL_SIZE = 256;
    private static final double load_factor = 0.75;
    private static final double increase_percent = 0.5;

    public Hashtable() {
        this.initTable();
    }

    private boolean putKV(K key, V value) {
        this.capacity_control();
        for (int r = 0; r < 256; ++r) {
            int idx = this.hash_decoder(key, r, 256);
            if (this.hashtable[idx] == null) {
                this.hashtable[idx] = new HashtableNode<K, V>(key, value);
                ++this.node_count;
                ++this.total_count;
                return true;
            }
            if (this.hashtable[idx] == null || !this.hashtable[idx].getKey().equals(key)) continue;
            this.hashtable[idx].add(value);
            ++this.total_count;
            return true;
        }
        return false;
    }

    private <E> int putAll(K key, E values) {
        int counter;
        block3: {
            block2: {
                counter = 0;
                if (!(values instanceof Object[])) break block2;
                for (Object each : (Object[])values) {
                    counter += this.putKV(key, each) ? 1 : 0;
                }
                break block3;
            }
            if (!(values instanceof List)) break block3;
            for (Object each : (List)values) {
                counter += this.putKV(key, each) ? 1 : 0;
            }
        }
        return counter;
    }

    public boolean put(K key, V value) {
        return this.putKV(key, value);
    }

    public int put(K key, V[] values) {
        return this.putAll(key, values);
    }

    public int put(K key, List<V> values) {
        return this.putAll(key, values);
    }

    private boolean containsK(K key) {
        for (HashtableNode<K, V> each : this.hashtable) {
            if (each == null || !each.equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean containsKV(K key, V value) {
        for (HashtableNode<K, V> each : this.hashtable) {
            if (each == null || !each.equals(key) || !each.getValues().contains(value)) continue;
            return true;
        }
        return false;
    }

    private boolean containsKV(K key, List<V> values) {
        boolean safe_check = false;
        for (HashtableNode<K, V> each : this.hashtable) {
            if (each == null || !each.equals(key)) continue;
            safe_check = true;
            for (V rsz_each : values) {
                if (each.getValues().contains(rsz_each)) continue;
                return false;
            }
        }
        return safe_check;
    }

    public boolean contains(K key) {
        return this.containsK(key);
    }

    public boolean contains(K key, V value) {
        return this.containsKV(key, value);
    }

    public boolean contains(K key, List<V> values) {
        return this.containsKV(key, values);
    }

    private List<V> getV(K key) {
        for (int r = 0; r < 256; ++r) {
            int idx = this.hash_decoder(key, r, 256);
            if (this.hashtable[idx] == null || !this.hashtable[idx].getKey().equals(key)) continue;
            return this.hashtable[idx].getValues();
        }
        return null;
    }

    public List<V> get(K key) {
        return this.getV(key);
    }

    private List<V> getIfV(K key, Predicate filter) {
        ArrayList newValues = new ArrayList();
        for (int r = 0; r < 256; ++r) {
            int idx = this.hash_decoder(key, r, 256);
            if (this.hashtable[idx] == null || !this.hashtable[idx].getKey().equals(key)) continue;
            this.hashtable[idx].getValues().forEach(each -> {
                if (filter.test(each)) {
                    newValues.add(each);
                }
            });
            return newValues;
        }
        return null;
    }

    public List<V> getIf(K key, Predicate filter) {
        return this.getIfV(key, filter);
    }

    private boolean removeK(K key) {
        for (int r = 0; r < 256; ++r) {
            int idx = this.hash_decoder(key, r, 256);
            if (this.hashtable[idx] == null || !this.hashtable[idx].getKey().equals(key)) continue;
            this.total_count -= this.hashtable[idx].getValues().size();
            --this.node_count;
            this.hashtable[idx] = null;
            return true;
        }
        return false;
    }

    public boolean remove(K key) {
        return this.removeK(key);
    }

    private boolean removeKV(K key, V value) {
        for (int r = 0; r < 256; ++r) {
            int idx = this.hash_decoder(key, r, 256);
            if (this.hashtable[idx] == null || !this.hashtable[idx].getKey().equals(key)) continue;
            if (this.hashtable[idx].getValues().remove(value)) {
                --this.total_count;
            }
            return true;
        }
        return false;
    }

    public boolean remove(K key, V value) {
        return this.removeKV(key, value);
    }

    private void initTable() {
        this.hashtable = (HashtableNode[])Array.newInstance(HashtableNode.class, 256);
        this.total_count = 0;
        this.node_count = 0;
    }

    public void clear() {
        this.initTable();
    }

    private boolean replaceK(K key, V oldValue, V newValue) {
        for (int r = 0; r < 256; ++r) {
            int idx = this.hash_decoder(key, r, 256);
            if (this.hashtable[idx] == null || !this.hashtable[idx].getKey().equals(key) || !this.hashtable[idx].getValues().remove(oldValue)) continue;
            return this.hashtable[idx].getValues().add(newValue);
        }
        return false;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replaceK(key, oldValue, newValue);
    }

    private List<V> replaceKV(K key, List<V> newValues) {
        ArrayList<V> oldValues = new ArrayList<V>();
        for (int r = 0; r < 256; ++r) {
            int idx = this.hash_decoder(key, r, 256);
            if (this.hashtable[idx] == null || !this.hashtable[idx].getKey().equals(key)) continue;
            if (this.hashtable[idx].getValues().size() < newValues.size()) {
                this.capacity_control(newValues.size() - this.hashtable[idx].getValues().size());
            }
            oldValues.addAll(this.hashtable[idx].getValues());
            int rmv_size = oldValues.size();
            this.hashtable[idx].getValues().clear();
            this.hashtable[idx].getValues().addAll(newValues);
            int add_size = this.hashtable[idx].getValues().size();
            this.total_count -= rmv_size;
            this.total_count += add_size;
            return oldValues;
        }
        return null;
    }

    public List<V> replace(K key, List<V> newValues) {
        return this.replaceKV(key, newValues);
    }

    private void capacity_control() {
        if (192.0 < (double)this.node_count) {
            int increase = (int)((double)this.node_count + (double)this.node_count * 0.5);
            this.hashtable = Arrays.copyOf(this.hashtable, increase);
        }
    }

    private void capacity_control(int len) {
        int line = 192;
        int limit = this.node_count + len;
        if (line < limit) {
            int increase = (int)((double)limit + (double)limit * 0.5);
            this.hashtable = Arrays.copyOf(this.hashtable, increase);
        }
    }

    private int hash_decoder(K key, int point, int size) {
        return (this.hash_function(key) + ((int)(Math.pow(point, 2.0) + (double)point) >> 2)) % size;
    }

    private int hash_function(K key) {
        String toHash = key.toString();
        int hashValue = 0;
        for (int pos = 0; pos < toHash.length(); ++pos) {
            int highBits = (hashValue = (hashValue << 4) + toHash.charAt(pos)) & 0xF0000000;
            if (highBits != 0) {
                hashValue ^= highBits >> 24;
            }
            hashValue &= ~highBits;
        }
        return hashValue;
    }

    public int size() {
        return this.node_count;
    }

    public int length() {
        return this.total_count;
    }
}

