/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import terraml.algorithm.DirectionCalculator;
import terraml.algorithm.GeoPoint;
import terraml.algorithm.PQuadtreeBuilder;
import terraml.algorithm.Quadrant;
import terraml.algorithm.node.PQuadNode;
import terraml.commons.Objects;
import terraml.commons.tuple.NativeEntry;
import terraml.commons.unit.DirectionUnit;

public class PQuadtree<Q>
implements Collection<Map.Entry<Q, GeoPoint>>,
Iterable<Map.Entry<Q, GeoPoint>> {
    public static final int DEFAULT_LIMIT = 256;
    private HashMap<String, Map.Entry<Q, GeoPoint>> objects;
    private PQuadNode root = null;
    private final int limit;
    private DirectionCalculator directionCalculator;

    public PQuadtree(DirectionCalculator dirCalc, Quadrant quadrant, int maxlimit) {
        this.directionCalculator = Objects.isNull((Object)dirCalc) ? new DirectionCalculator(){

            @Override
            public DirectionUnit of(GeoPoint from, GeoPoint to) {
                return this.fromAzimuth(from, to);
            }
        } : dirCalc;
        this.limit = maxlimit;
        this.objects = new HashMap(this.limit);
        this.root = new PQuadNode();
        this.root.setParent(null);
        this.root.setCoordinate(null);
        this.root.setQuadrant(quadrant);
        this.root.split();
    }

    public PQuadtree(PQuadtreeBuilder<Q> builder) {
        this(builder.getDirectionCalculator(), builder.getQuadrant(), builder.getLimit());
    }

    public PQuadtree(DirectionCalculator dirCalc, Quadrant quadrant) {
        this(dirCalc, quadrant, 256);
    }

    public PQuadtree(DirectionCalculator dirCalc, GeoPoint p0, GeoPoint p1) {
        this(dirCalc, new Quadrant(p0, p1));
    }

    public Collection<Map.Entry<Q, GeoPoint>> query(GeoPoint p0, GeoPoint p1) {
        Quadrant quadrant = new Quadrant(p0, p1);
        PQuadNode quadNode = this.getRoot();
        ArrayList<Map.Entry<Q, GeoPoint>> collector = new ArrayList<Map.Entry<Q, GeoPoint>>();
        return this.query(quadNode, collector, quadrant);
    }

    protected Collection<Map.Entry<Q, GeoPoint>> query(PQuadNode src, Collection<Map.Entry<Q, GeoPoint>> collector, Quadrant quadrant) {
        if (Objects.isNull((Object)src)) {
            return collector;
        }
        boolean intersectionExists = src.getQuadrant().intersects(quadrant);
        boolean containmentExists = src.getQuadrant().contains(quadrant);
        if (!intersectionExists && !containmentExists) {
            return collector;
        }
        boolean isCellGroup = Objects.isNull((Object)src.getCoordinate());
        if (!isCellGroup) {
            GeoPoint coordinate = src.getCoordinate();
            String id = coordinate.getId();
            Map.Entry<Q, GeoPoint> entry = this.getObjects().get(id);
            if (quadrant.contains(coordinate)) {
                collector.add(entry);
            }
        }
        collector = this.query(src.getNorthEastNode(), collector, quadrant);
        collector = this.query(src.getNorthWestNode(), collector, quadrant);
        collector = this.query(src.getSouthEastNode(), collector, quadrant);
        collector = this.query(src.getSouthWestNode(), collector, quadrant);
        return collector;
    }

    protected PQuadNode move(PQuadNode quadNode, GeoPoint coordinate) {
        PQuadNode reference = quadNode;
        while (true) {
            DirectionUnit quadrant;
            if ((quadrant = this.directionCalculator.of(reference.getQuadrant().getCenter(), coordinate)).equals((Object)DirectionUnit.NORTH_WEST)) {
                if (Objects.isNull((Object)reference.getNorthWestNode())) break;
                reference = reference.getNorthWestNode();
                continue;
            }
            if (quadrant.equals((Object)DirectionUnit.NORTH_EAST)) {
                if (Objects.isNull((Object)reference.getNorthEastNode())) break;
                reference = reference.getNorthEastNode();
                continue;
            }
            if (quadrant.equals((Object)DirectionUnit.SOUTH_EAST)) {
                if (Objects.isNull((Object)reference.getSouthEastNode())) break;
                reference = reference.getSouthEastNode();
                continue;
            }
            if (!quadrant.equals((Object)DirectionUnit.SOUTH_WEST)) continue;
            if (Objects.isNull((Object)reference.getSouthWestNode())) break;
            reference = reference.getSouthWestNode();
        }
        return reference;
    }

    protected String add(PQuadNode reference, GeoPoint coordinate) {
        String id;
        if (Objects.isNull((Object)(reference = this.move(reference, coordinate)).getCoordinate())) {
            reference.setCoordinate(coordinate);
            id = coordinate.getId();
        } else {
            while (Objects.nonNull((Object)reference.getCoordinate())) {
                GeoPoint coord = reference.getCoordinate();
                reference.split();
                this.add(reference, coord);
            }
            reference.setCoordinate(coordinate);
            id = coordinate.getId();
        }
        return id;
    }

    protected boolean inBounds(GeoPoint p0) {
        return Quadrant.contains(this.getRoot().getQuadrant(), p0);
    }

    public String add(Q data, GeoPoint p0) {
        String id = null;
        if (this.inBounds(p0)) {
            GeoPoint coordinate = p0;
            id = this.add(this.getRoot(), coordinate);
            if (Objects.nonNull((Object)id)) {
                this.getObjects().put(id, (Map.Entry<Q, GeoPoint>)NativeEntry.of(data, (Object)p0));
            }
        }
        return id;
    }

    @Override
    public boolean add(Map.Entry<Q, GeoPoint> entry) {
        return this.add(entry.getKey(), entry.getValue()) != null;
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<Q, GeoPoint>> c) {
        for (Map.Entry<Q, GeoPoint> each : c) {
            if (this.add(each)) continue;
            return false;
        }
        return true;
    }

    protected boolean contains(GeoPoint coordinate) {
        PQuadNode reference = this.getRoot();
        boolean found = false;
        while (true) {
            if (Objects.nonNull((Object)reference.getCoordinate()) && reference.getCoordinate().equals(coordinate)) {
                found = true;
                break;
            }
            DirectionUnit quadrant = this.directionCalculator.of(reference.getQuadrant().getCenter(), coordinate);
            if (quadrant.equals((Object)DirectionUnit.NORTH_WEST)) {
                if (Objects.isNull((Object)reference.getNorthWestNode())) break;
                reference = reference.getNorthWestNode();
                continue;
            }
            if (quadrant.equals((Object)DirectionUnit.NORTH_EAST)) {
                if (Objects.isNull((Object)reference.getNorthEastNode())) break;
                reference = reference.getNorthEastNode();
                continue;
            }
            if (quadrant.equals((Object)DirectionUnit.SOUTH_EAST)) {
                if (Objects.isNull((Object)reference.getSouthEastNode())) break;
                reference = reference.getSouthEastNode();
                continue;
            }
            if (!quadrant.equals((Object)DirectionUnit.SOUTH_WEST)) continue;
            if (Objects.isNull((Object)reference.getSouthWestNode())) break;
            reference = reference.getSouthWestNode();
        }
        return found;
    }

    public boolean contains(Q data, GeoPoint geoPoint) {
        if (Objects.isNull((Object)geoPoint.getId())) {
            return false;
        }
        Map.Entry<Q, GeoPoint> entry = this.getObjects().get(geoPoint.getId());
        boolean keyMatch = entry.getKey().equals(data);
        boolean valMatch = entry.getValue().equals(geoPoint);
        return keyMatch && valMatch;
    }

    public boolean contains(Map.Entry<Q, GeoPoint> entry) {
        return this.contains(entry.getKey(), entry.getValue());
    }

    @Override
    public boolean contains(Object object) {
        Map.Entry entry = (Map.Entry)object;
        return this.contains(entry);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object each : c) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    protected List<Quadrant> boundries(PQuadNode quadNode, List<Quadrant> collector) {
        if (quadNode == null) {
            return collector;
        }
        if (quadNode.getQuadrant() != null) {
            Quadrant temp = quadNode.getQuadrant();
            collector.add(temp);
        }
        collector = this.boundries(quadNode.getNorthEastNode(), collector);
        collector = this.boundries(quadNode.getNorthWestNode(), collector);
        collector = this.boundries(quadNode.getSouthEastNode(), collector);
        collector = this.boundries(quadNode.getSouthWestNode(), collector);
        return collector;
    }

    public Enumeration<Quadrant> boundries() {
        PQuadNode reference = this.getRoot();
        final List<Quadrant> list = this.boundries(reference, new ArrayList<Quadrant>());
        final int length = list.size();
        return new Enumeration<Quadrant>(){
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < length;
            }

            @Override
            public Quadrant nextElement() {
                if (this.hasMoreElements()) {
                    return (Quadrant)list.get(this.index++);
                }
                throw new NoSuchElementException("NoSuchElementException");
            }
        };
    }

    protected Collection<GeoPoint> distinct(PQuadNode quadNode, Collection<GeoPoint> collector) {
        if (Objects.isNull((Object)quadNode)) {
            return collector;
        }
        if (Objects.nonNull((Object)quadNode.getCoordinate())) {
            collector.add(quadNode.getCoordinate());
        }
        collector = this.distinct(quadNode.getNorthEastNode(), collector);
        collector = this.distinct(quadNode.getNorthWestNode(), collector);
        collector = this.distinct(quadNode.getSouthEastNode(), collector);
        collector = this.distinct(quadNode.getSouthWestNode(), collector);
        return collector;
    }

    @Override
    public Iterator<Map.Entry<Q, GeoPoint>> iterator() {
        return this.getObjects().values().iterator();
    }

    public Collection<Map.Entry<Q, GeoPoint>> collection() {
        return this.getObjects().values();
    }

    @Override
    public Object[] toArray() {
        PQuadNode ref = this.getRoot();
        return this.distinct(ref, new ArrayList<GeoPoint>()).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        PQuadNode ref = this.getRoot();
        return this.distinct(ref, new ArrayList<GeoPoint>()).toArray(a);
    }

    @Override
    public int size() {
        if (Objects.isNull(this.getObjects())) {
            return 0;
        }
        return this.getObjects().keySet().size();
    }

    @Override
    public void clear() {
        this.setObjects(null);
        this.setRoot(null);
    }

    @Override
    public boolean isEmpty() {
        return Objects.isNull((Object)this.getRoot());
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PQuadNode getRoot() {
        return this.root;
    }

    public void setRoot(PQuadNode root) {
        this.root = root;
    }

    public HashMap<String, Map.Entry<Q, GeoPoint>> getObjects() {
        return this.objects;
    }

    public void setObjects(HashMap<String, Map.Entry<Q, GeoPoint>> objects) {
        this.objects = objects;
    }

    public int getLimit() {
        return this.limit;
    }
}

