/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm.iterator;

import java.util.Iterator;
import java.util.LinkedList;
import terraml.algorithm.node.AVLNode;

public class AVLOrderedTraversal<Q>
implements Iterator<Q> {
    private final LinkedList<AVLNode<Q>> linkedList = new LinkedList();
    private LinkedList<Q> temp;
    private boolean remained = false;

    public AVLOrderedTraversal(AVLNode<Q> root) {
        AVLNode<Q> instance;
        for (AVLNode<Q> current = instance = root; current != null; current = current.getLeft()) {
            this.linkedList.push(current);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.linkedList.isEmpty();
    }

    @Override
    public Q next() {
        Object next;
        AVLNode<Q> current = this.linkedList.peek();
        if (this.temp != null && !this.temp.isEmpty() && (next = this.temp.pop()) != null) {
            return (Q)next;
        }
        if (current.getDuplicates() != null && !current.getDuplicates().isEmpty()) {
            if (this.temp == null) {
                this.temp = new LinkedList();
            }
            for (Object each : current.getDuplicates()) {
                this.temp.add(each);
            }
        } else {
            this.linkedList.poll();
            for (AVLNode<Q> child = current.getRight(); child != null; child = child.getLeft()) {
                this.linkedList.push(child);
            }
            return current.getData();
        }
        this.linkedList.poll();
        return current.getData();
    }
}

