/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm.node;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class AStarNode<Q>
implements Serializable {
    private final Q id;
    private final Map<Q, Double> heuristic;
    private double distanceFromSource;
    private double heuristicOfDestination;
    private double cost;

    public AStarNode(Q nodeId, Map<Q, Double> heuristic) {
        this.id = nodeId;
        this.distanceFromSource = Double.MAX_VALUE;
        this.heuristic = heuristic;
    }

    public Q getId() {
        return this.id;
    }

    public double getDistanceFromSource() {
        return this.distanceFromSource;
    }

    public void setDistanceFromSource(double distanceFromSource) {
        this.distanceFromSource = distanceFromSource;
    }

    public void calcF(Q destination) {
        this.heuristicOfDestination = this.heuristic.get(destination);
        this.cost = this.distanceFromSource + this.heuristicOfDestination;
    }

    public double getHeuristicOfDestination() {
        return this.heuristicOfDestination;
    }

    public double getCost() {
        return this.cost;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.id);
        hash = 89 * hash + Objects.hashCode(this.heuristic);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.distanceFromSource) ^ Double.doubleToLongBits(this.distanceFromSource) >>> 32);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.heuristicOfDestination) ^ Double.doubleToLongBits(this.heuristicOfDestination) >>> 32);
        hash = 89 * hash + (int)(Double.doubleToLongBits(this.cost) ^ Double.doubleToLongBits(this.cost) >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AStarNode other = (AStarNode)obj;
        if (Double.doubleToLongBits(this.distanceFromSource) != Double.doubleToLongBits(other.distanceFromSource)) {
            return false;
        }
        if (Double.doubleToLongBits(this.heuristicOfDestination) != Double.doubleToLongBits(other.heuristicOfDestination)) {
            return false;
        }
        if (Double.doubleToLongBits(this.cost) != Double.doubleToLongBits(other.cost)) {
            return false;
        }
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.heuristic, other.heuristic);
    }
}

