/*
 * Decompiled with CFR 0.152.
 */
package terraml.algorithm.node;

import java.io.Serializable;
import java.util.Objects;
import terraml.algorithm.GeoPoint;
import terraml.algorithm.Quadrant;

public class PQuadNode
implements Serializable {
    private Quadrant quadrant;
    private GeoPoint coordinate;
    private PQuadNode parent;
    private TypeEnum typeEnum = TypeEnum.CELL;
    private PQuadNode southWestNode;
    private PQuadNode northEastNode;
    private PQuadNode northWestNode;
    private PQuadNode southEastNode;

    public PQuadNode() {
    }

    public PQuadNode(GeoPoint coordinate) {
        this.coordinate = coordinate;
    }

    public void split() {
        this.setNorthEastNode(new PQuadNode());
        this.getNorthEastNode().setQuadrant(new Quadrant(this.getQuadrant().getCenter(), this.getQuadrant().getNe()));
        this.getNorthEastNode().setParent(this);
        this.setSouthEastNode(new PQuadNode());
        this.getSouthEastNode().setQuadrant(new Quadrant(this.getQuadrant().getCenter(), this.getQuadrant().getSe()));
        this.getSouthEastNode().setParent(this);
        this.setSouthWestNode(new PQuadNode());
        this.getSouthWestNode().setQuadrant(new Quadrant(this.getQuadrant().getCenter(), this.getQuadrant().getSw()));
        this.getSouthWestNode().setParent(this);
        this.setNorthWestNode(new PQuadNode());
        this.getNorthWestNode().setQuadrant(new Quadrant(this.getQuadrant().getCenter(), this.getQuadrant().getNw()));
        this.getNorthWestNode().setParent(this);
        this.setCoordinate(null);
        this.setTypeEnum(TypeEnum.CELL_GROUP);
    }

    public boolean isNorthWestEmpty() {
        return terraml.commons.Objects.isNull((Object)this.getNorthWestNode());
    }

    public boolean isNorthEastEmpty() {
        return terraml.commons.Objects.isNull((Object)this.getNorthEastNode());
    }

    public boolean isSouthEastEmpty() {
        return terraml.commons.Objects.isNull((Object)this.getSouthEastNode());
    }

    public boolean isSouthWestEmpty() {
        return terraml.commons.Objects.isNull((Object)this.getSouthWestNode());
    }

    public boolean isLeaf() {
        return this.isNorthWestEmpty() && this.isNorthEastEmpty() && this.isSouthEastEmpty() && this.isSouthWestEmpty();
    }

    public boolean isOrphan() {
        return terraml.commons.Objects.isNull((Object)this.getParent());
    }

    public Quadrant getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(Quadrant quadrant) {
        this.quadrant = quadrant;
    }

    public GeoPoint getCoordinate() {
        return this.coordinate;
    }

    public void setCoordinate(GeoPoint coordinate) {
        this.coordinate = coordinate;
    }

    public PQuadNode getParent() {
        return this.parent;
    }

    public void setParent(PQuadNode parent) {
        this.parent = parent;
    }

    public TypeEnum getTypeEnum() {
        return this.typeEnum;
    }

    public void setTypeEnum(TypeEnum typeEnum) {
        this.typeEnum = typeEnum;
    }

    public PQuadNode getSouthWestNode() {
        return this.southWestNode;
    }

    public void setSouthWestNode(PQuadNode southWestNode) {
        this.southWestNode = southWestNode;
    }

    public PQuadNode getNorthEastNode() {
        return this.northEastNode;
    }

    public void setNorthEastNode(PQuadNode northEastNode) {
        this.northEastNode = northEastNode;
    }

    public PQuadNode getNorthWestNode() {
        return this.northWestNode;
    }

    public void setNorthWestNode(PQuadNode northWestNode) {
        this.northWestNode = northWestNode;
    }

    public PQuadNode getSouthEastNode() {
        return this.southEastNode;
    }

    public void setSouthEastNode(PQuadNode southEastNode) {
        this.southEastNode = southEastNode;
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + Objects.hashCode(this.quadrant);
        hash = 11 * hash + Objects.hashCode(this.coordinate);
        hash = 11 * hash + Objects.hashCode(this.parent);
        hash = 11 * hash + Objects.hashCode((Object)this.typeEnum);
        hash = 11 * hash + Objects.hashCode(this.southWestNode);
        hash = 11 * hash + Objects.hashCode(this.northEastNode);
        hash = 11 * hash + Objects.hashCode(this.northWestNode);
        hash = 11 * hash + Objects.hashCode(this.southEastNode);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PQuadNode other = (PQuadNode)obj;
        if (!Objects.equals(this.quadrant, other.quadrant)) {
            return false;
        }
        if (!Objects.equals(this.coordinate, other.coordinate)) {
            return false;
        }
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        if (this.typeEnum != other.typeEnum) {
            return false;
        }
        if (!Objects.equals(this.southWestNode, other.southWestNode)) {
            return false;
        }
        if (!Objects.equals(this.northEastNode, other.northEastNode)) {
            return false;
        }
        if (!Objects.equals(this.northWestNode, other.northWestNode)) {
            return false;
        }
        return Objects.equals(this.southEastNode, other.southEastNode);
    }

    public static enum TypeEnum {
        CELL,
        CELL_GROUP;

    }
}

