/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geospatial  project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.geospatial;

import java.io.Serializable;
import java.util.Objects;
import terraml.commons.annotation.File;
import terraml.commons.tuple.LatlonEntry;

// Esiri miyiz para ya da maddelerin?
/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
@File(
        fileName = "GeoBoundry.java",
        packageName = "terraml.geospatial",
        projectName = "terraml-geospatial"
)
public class GeoBoundry implements Serializable {

    public final LatlonEntry lowerBound;
    public final LatlonEntry upperBound;

    /**
     * @param LatlonEntry
     * @param LatlonEntry
     */
    public GeoBoundry(LatlonEntry lowerBound, LatlonEntry upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public LatlonEntry getLowerBound() {
        return lowerBound;
    }

    public LatlonEntry getUpperBound() {
        return upperBound;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.lowerBound);
        hash = 41 * hash + Objects.hashCode(this.upperBound);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final GeoBoundry other = (GeoBoundry) obj;
        if (!Objects.equals(this.lowerBound, other.lowerBound)) {
            return false;
        }
        return Objects.equals(this.upperBound, other.upperBound);
    }

}
