/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geospatial  project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.geospatial;

import terraml.commons.annotation.Development;
import terraml.commons.annotation.Issue;
import terraml.commons.math.Angle;

// bana tepeler denizler dar.
/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public interface GeoCircle extends GeoShape {

    /**
     * @param coordinate
     * @return true if GeoCircle contains given Latlon. Otherwise false.
     */
    @Development(status = Development.Status.STABLE)
    public boolean contains(Latlon coordinate);

    /**
     * @param coordinate
     * @return true if GeoCircle contains given GeoCircle. Otherwise false.
     */
    @Development(status = Development.Status.STABLE)
    public boolean contains(GeoCircle geoCircle);

    /**
     * @param circle
     * @return true if GeoCircle intersects with given GeoCircle. Otherwise false.
     */
    @Issue(
            category = Issue.Type.ENHANCEMENT,
            content = "TMLSPA-4",
            isFixed = false,
            issueId = "TMLSPA-4"
    )
    public boolean intersects(GeoCircle circle);

    /**
     * @param DistanceNode
     * @param Angle
     * @return throws UnsupportedOperationException.
     */
    @Issue(
            category = Issue.Type.ENHANCEMENT,
            content = "throws UnsupportedOperationException.",
            isFixed = false,
            issueId = "TMLSPA-5"
    )
    public GeoCircle offset(DistanceNode distanceNode, Angle bearing);

    /**
     * @return
     */
    public double area();

    /**
     * @return
     */
    public GeoPolyline toOctagon();

    /**
     * @return
     */
    public GeoPolyline to2xOctagon();

    /**
     * @return
     */
    public Latlon getCenter();

    /**
     * @return
     */
    public DistanceNode getRadius();

    /**
     * @return
     */
    public double[] toArray();

    @Override
    public GeoCircle clone();

    @Override
    public GeoShapeUnit getGeoShapeUnit();

    /**
     * This calculats outer bounds of circle.
     * <p>
     * <p>
     * #################################
     * # #
     * # # #
     * # # #
     * # # #
     * # # #
     * # # #
     * # # #
     * # #
     * # #
     * # #
     * # #
     * # #
     * #################################
     *
     *
     * @return OUTER BOUNDS
     */
    @Override
    public Latlon[] getBounds();
}
