/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geospatial  project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.geospatial;

import java.util.Collection;
import java.util.List;
import terraml.commons.annotation.Development;

// biz yakarsak söndüremezler.
/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public interface GeoPolygon extends GeoShape {

    // dozajı kaçırmışlar kim ki bunlar ?
    /**
     * @param coordinate
     * @return
     */
    @Development(status = Development.Status.STABLE)
    public boolean contains(Latlon coordinate);

    /**
     * @param polygon
     * @return
     */
    @Development(status = Development.Status.STABLE)
    public boolean contains(GeoPolygon polygon);

    /**
     * @param polygon
     * @return
     */
    @Development(status = Development.Status.STABLE)
    public boolean intersects(GeoPolygon polygon);

    /**
     * @return segments version of this. Method will return segments as closed-polygon, even this is not closed.
     */
    public Collection<GeoSegment> toSegments();

    /**
     * @return
     */
    public boolean isValid();

    /**
     * @return
     */
    public boolean isClosed();

    /**
     * @return
     */
    public boolean isProper();

    /**
     * @return
     */
    public boolean prepare();

    /**
     * @param vertex
     * @return
     */
    public GeoPolygon addVertex(Latlon vertex);

    /**
     * @param vertex
     * @return
     */
    public GeoPolygon removeVertex(Latlon vertex);

    /**
     * @return
     */
    public List<Latlon> getVertices();

    /**
     * @return
     */
    public Latlon[] toArray();

    /**
     * @return
     */
    public List<Latlon> toList();

    /**
     * @return
     */
    public int getVerticesCount();

    @Override
    public GeoPolygon clone();

    @Override
    public GeoShapeUnit getGeoShapeUnit();

    @Override
    public Latlon[] getBounds();
}
