/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geospatial  project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.geospatial;

import java.util.Collection;
import java.util.List;
import terraml.commons.annotation.Development;
import terraml.commons.tuple.Pair;

// burda panda yok develer var.
/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public interface GeoPolyline extends GeoShape {

    /**
     * @param coordinate
     * @param isMin      minimum or maximum crosstrack
     * @param isVincenty calculate with vincenty or haversine
     * @return
     */
    public double crossTrack(Latlon coordinate, boolean isMin, boolean isVincenty);

    /**
     *
     * @param polyline
     * @return
     */
    @Development(status = Development.Status.STABLE)
    public boolean intersects(GeoPolyline polyline);

    /**
     * @param polyline
     * @param toleranceMeter
     * @return
     */
    @Development(status = Development.Status.STABLE)
    public Collection<Latlon> intersection(GeoPolyline polyline, DistanceNode tolerance);

    /**
     * @param point
     * @param toleranceMeters
     * @return
     */
    public boolean isOn(Latlon point, DistanceNode tolerance);

    /**
     * @param point
     * @param calculator
     * @param toleranceMeters
     * @return
     */
    public boolean isOn(Latlon point, DistanceCalculator calculator, DistanceNode tolerance);

    /**
     * @param coord
     * @param calculator
     * @return
     */
    public Pair<Latlon, DistanceNode> closestOf(Latlon coord, DistanceCalculator calculator);

    /**
     * @param distanceMeter
     * @return
     */
    @Development(status = Development.Status.STABLE)
    public Latlon find(DistanceNode distance);

    /**
     * @return
     */
    @Development(status = Development.Status.STABLE)
    public Latlon centroid();

    /**
     * It creates segments like: [polyline-coordinate]---SEGMENT---[next-polyline-coordinate]...[last-polyline-coordinate]
     *
     * @return list of segments.
     */
    public Collection<GeoSegment> toSegments();

    /**
     * @return
     */
    public Latlon[] toArray();

    /**
     * @return
     */
    public List<Latlon> toList();

    @Override
    public GeoPolyline clone();

    @Override
    public GeoShapeUnit getGeoShapeUnit();

    @Override
    public Latlon[] getBounds();
}
