/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * This file is part of terraml-geospatial  project.
 *
 * This file incorporates work covered by
 * the following copyright and permission notices:
 *
 * Copyright (C) 2018 Terra Software Informatics LLC. | info [at] terrayazilim [dot] com [dot] tr
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package terraml.geospatial;

import terraml.commons.annotation.Development;

// bizi heyecanlandırmıyorsa bir şeyler, artık öldüremezler...
/**
 * @author M.Çağrı Tepebaşılı - cagritepebasili [at] protonmail [dot] com
 * @version 1.0.0-SNAPSHOT
 */
public interface GeoSegment extends GeoShape {

    /**
     *
     * @param segment
     * @param tolerance as meter
     * @return
     */
    public boolean intersects(GeoSegment segment, DistanceNode tolerance);

    /**
     * @param segment
     * @return
     */
    public boolean intersects(GeoSegment segment);

    /**
     * @param segment      GeoSegment
     * @param DistanceNode as meter
     * @return Intersection Latlon. If there is no intersection then null.
     */
    @Development(status = Development.Status.STABLE)
    public Latlon intersection(GeoSegment segment, DistanceNode tolerance);

    /**
     * @param DistanceNode
     * @return A new GeoSegment that's source Latlon is offsetted with given DistanceNode.
     */
    public GeoSegment offset(DistanceNode distanceNode);

    /**
     * @param Latlon
     * @return
     */
    public DistanceNode vinCrosstrack(Latlon latlon);

    /**
     * @param Latlon
     * @return
     */
    public DistanceNode havCrosstrack(Latlon latlon);

    /**
     * @param Latlon
     * @param DistanceNode
     * @param DistanceCalculator
     * @return
     */
    public boolean isOn(Latlon latlon, DistanceNode tolerance, DistanceCalculator calculator);

    /**
     * @param Latlon
     * @param DistanceNode
     * @return
     */
    public boolean isOn(Latlon latlon, DistanceNode tolerance);

    /**
     * @param DistanceCalculator
     * @return
     */
    public DistanceNode distance(DistanceCalculator calculator);

    /**
     * @param Latlon
     * @param DistanceCalculator
     * @return
     */
    public Latlon closestOf(Latlon latlon, DistanceCalculator calculator);

    /**
     * @param Latlon
     * @return
     */
    public boolean inZone(Latlon latlon);

    /**
     * @return
     */
    public Latlon halfway();

    /**
     * @param double
     * @return
     */
    public Latlon at(double percentage);

    /**
     * @return
     */
    public Latlon getSource();

    /**
     * @return
     */
    public Latlon getTarget();

    /**
     * @return
     */
    public Latlon[] toArray();

    /**
     * @return
     */
    public double[] toDoubleArray();

    @Override
    public GeoSegment clone();

    @Override
    public GeoShapeUnit getGeoShapeUnit();

    @Override
    public Latlon[] getBounds();
}
