package online.xcodes.ip;

import java.util.Objects;
import java.util.Set;

public class IPUtil {

    private static final String ANY_IP="*";
    public static boolean isWhiteIp(String ip, Set<String> whiteIps){
        if(whiteIps==null || whiteIps.isEmpty()){return false;}
        if(whiteIps.contains(ANY_IP)){return true;}
        //非法IP直接返回false
        if(ip==null || !ip.matches("^[\\d]+\\.[\\d]+\\.[\\d]+\\.[\\d]+$")){return false;}
        return whiteIps.stream().anyMatch(cidr->isInRange(ip,cidr));
    }


    public static boolean isInRange(String ip, String cidr) {
        if(ip==null || cidr==null || !cidr.contains("/")){return Objects.equals(ip,cidr);}
        // 取出指定网段的子网掩码,即'/'后的数字,此为CIDR斜线记法
        String[] cidrArray = cidr.split("/", 2);
        int mask = 0xFFFFFFFF << (32 - Integer.parseInt(cidrArray[1]));

        String[] ips = ip.split("\\.");
        String[] cidrIps = cidrArray[0].split("\\.");
        try {
            // 两个IP分别与掩码做与运算,结果相等则返回True
            return ips.length == 4 && cidrIps.length == 4 && (ipv42Int(ips) & mask) == (ipv42Int(cidrIps) & mask);
        }catch(NumberFormatException ignore){
            //兼容非法IP和非法CIDR的情况
            return Objects.equals(ip,cidr);
        }
    }

    //IPV4转化成数字
    private static int ipv42Int(String[] ips){
        // 通过移位和或运算把子网IP由字符串数组转化为整数
        return (Integer.parseInt(ips[0]) << 24) | (Integer.parseInt(ips[1]) << 16) | (Integer.parseInt(ips[2]) << 8) | (Integer.parseInt(ips[3]));
    }

}
