/*
 * Decompiled with CFR 0.152.
 */
package online.xcodes.ip;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import online.xcodes.ip.QQWry;
import org.apache.commons.lang3.StringUtils;

public class IPLocationUtil {
    public static final String INIT_QQWRY_ERROR = "\u521d\u59cb\u5316qqwry\u5931\u8d25";
    private static final String COUNTRY_CHINA = "\u4e2d\u56fd";
    private static final List<String> PROVINCES_CHINA = ImmutableList.of((Object)"\u9ed1\u9f99\u6c5f\u7701", (Object)"\u8fbd\u5b81\u7701", (Object)"\u5409\u6797\u7701", (Object)"\u6cb3\u5317\u7701", (Object)"\u6cb3\u5357\u7701", (Object)"\u6e56\u5317\u7701", (Object)"\u6e56\u5357\u7701", (Object)"\u5c71\u4e1c\u7701", (Object)"\u5c71\u897f\u7701", (Object)"\u9655\u897f\u7701", (Object)"\u5b89\u5fbd\u7701", (Object)"\u6d59\u6c5f\u7701", (Object[])new String[]{"\u6c5f\u82cf\u7701", "\u798f\u5efa\u7701", "\u5e7f\u4e1c\u7701", "\u6d77\u5357\u7701", "\u56db\u5ddd\u7701", "\u4e91\u5357\u7701", "\u8d35\u5dde\u7701", "\u9752\u6d77\u7701", "\u7518\u8083\u7701", "\u6c5f\u897f\u7701", "\u53f0\u6e7e\u7701", "\u5185\u8499\u53e4", "\u5b81\u590f", "\u65b0\u7586", "\u897f\u85cf", "\u5e7f\u897f", "\u5317\u4eac\u5e02", "\u4e0a\u6d77\u5e02", "\u5929\u6d25\u5e02", "\u91cd\u5e86\u5e02", "\u9999\u6e2f", "\u6fb3\u95e8"});
    private static final List<String> ISPS_CHINA = ImmutableList.of((Object)"\u8054\u901a", (Object)"\u79fb\u52a8", (Object)"\u94c1\u901a", (Object)"\u7535\u4fe1", (Object)"\u957f\u57ce", (Object)"\u805a\u53cb");
    private static Cache<String, IPLocation> cache = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private static QQWry qqwry;

    public static IPLocation search(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return new IPLocation();
        }
        if (!(InetAddress.getByName(ip) instanceof Inet4Address)) {
            return new IPLocation();
        }
        return (IPLocation)cache.get((Object)ip, () -> IPLocationUtil.convert(IPLocationUtil.getQQWry().findIP(ip)));
    }

    private static IPLocation convert(QQWry.IPZone ipZone) {
        IPLocation ipLocation = new IPLocation();
        ipLocation.setArea(ipZone.getMainInfo());
        if ("\u7eaf\u771f\u7f51\u7edc".equals(ipZone.getMainInfo())) {
            ipLocation.setCountry("IANA");
            ipLocation.setProvince("");
            ipLocation.setCity("");
            ipLocation.setIsp("");
            ipLocation.setArea("\u4fdd\u7559\u5730\u5740");
            return ipLocation;
        }
        String province = IPLocationUtil.getProvince(ipZone.getMainInfo());
        if (province != null) {
            ipLocation.setCountry(COUNTRY_CHINA);
            ipLocation.setProvince(province);
            ipLocation.setCity(ipZone.getMainInfo().replace(province, ""));
        } else {
            ipLocation.setCountry(ipZone.getMainInfo());
            ipLocation.setProvince("");
            ipLocation.setCity("");
        }
        String isp = IPLocationUtil.getISP(ipZone.getSubInfo());
        if (isp != null) {
            ipLocation.setIsp(isp);
        } else if ("CZ88.NET".equals(ipZone.getSubInfo()) || "\u7eaf\u771f\u7f51\u7edc".equals(ipZone.getSubInfo())) {
            ipLocation.setIsp("");
        } else {
            ipLocation.setIsp(ipZone.getSubInfo());
        }
        return ipLocation;
    }

    private static String getProvince(String mainInfo) {
        for (String province : PROVINCES_CHINA) {
            if (!mainInfo.contains(province)) continue;
            return province;
        }
        return null;
    }

    private static String getISP(String subInfo) {
        for (String isp : ISPS_CHINA) {
            if (!subInfo.contains(isp)) continue;
            return isp;
        }
        return null;
    }

    private static QQWry getQQWry() {
        if (qqwry != null) {
            return qqwry;
        }
        Class<IPLocationUtil> clazz = IPLocationUtil.class;
        synchronized (IPLocationUtil.class) {
            if (qqwry != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return qqwry;
            }
            try {
                qqwry = new QQWry();
                // ** MonitorExit[var0] (shouldn't be in output)
                return qqwry;
            }
            catch (Exception e) {
                throw new RuntimeException(INIT_QQWRY_ERROR, e);
            }
        }
    }

    public static class IPLocation {
        private String country;
        private String area;
        private String isp;
        private String province;
        private String city;

        public String getCountry() {
            return this.country;
        }

        public String getArea() {
            return this.area;
        }

        public String getIsp() {
            return this.isp;
        }

        public String getProvince() {
            return this.province;
        }

        public String getCity() {
            return this.city;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public void setArea(String area) {
            this.area = area;
        }

        public void setIsp(String isp) {
            this.isp = isp;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IPLocation)) {
                return false;
            }
            IPLocation other = (IPLocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$area = this.getArea();
            String other$area = other.getArea();
            if (this$area == null ? other$area != null : !this$area.equals(other$area)) {
                return false;
            }
            String this$isp = this.getIsp();
            String other$isp = other.getIsp();
            if (this$isp == null ? other$isp != null : !this$isp.equals(other$isp)) {
                return false;
            }
            String this$province = this.getProvince();
            String other$province = other.getProvince();
            if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            return !(this$city == null ? other$city != null : !this$city.equals(other$city));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IPLocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $area = this.getArea();
            result = result * 59 + ($area == null ? 43 : $area.hashCode());
            String $isp = this.getIsp();
            result = result * 59 + ($isp == null ? 43 : $isp.hashCode());
            String $province = this.getProvince();
            result = result * 59 + ($province == null ? 43 : $province.hashCode());
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            return result;
        }

        public String toString() {
            return "IPLocationUtil.IPLocation(country=" + this.getCountry() + ", area=" + this.getArea() + ", isp=" + this.getIsp() + ", province=" + this.getProvince() + ", city=" + this.getCity() + ")";
        }
    }
}

