/*
 * Decompiled with CFR 0.152.
 */
package online.yangcloud.utils;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CurrentTimeGetter {
    private volatile long now = System.currentTimeMillis();

    private CurrentTimeGetter() {
        this.scheduleTick();
    }

    private void scheduleTick() {
        new ScheduledThreadPoolExecutor(1, runnable -> {
            Thread thread = new Thread(runnable, "current-time-millis");
            thread.setDaemon(true);
            return thread;
        }).scheduleAtFixedRate(() -> {
            this.now = System.currentTimeMillis();
        }, 1L, 1L, TimeUnit.MILLISECONDS);
    }

    public static long now() {
        return SingletonHolder.INSTANCE.now;
    }

    private static CurrentTimeGetter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final CurrentTimeGetter INSTANCE = new CurrentTimeGetter();

        private SingletonHolder() {
        }
    }
}

