/*
 * Decompiled with CFR 0.152.
 */
package online.yangcloud.common;

public class ResponseResult {
    private static final int HTTP_EXCEPTION = 555;
    private static final String NONE_STRING = "";
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    private Integer status;
    private String msg;
    private Object data;
    private String ok;

    public static ResponseResult build(Integer status, String msg, Object data) {
        return new ResponseResult(status, msg, data);
    }

    public static ResponseResult build(Integer status, String msg, Object data, String ok) {
        return new ResponseResult(status, msg, data, ok);
    }

    public static ResponseResult ok(Object data) {
        return new ResponseResult(200, NONE_STRING, data);
    }

    public static ResponseResult ok(String msg, Object data) {
        return new ResponseResult(200, msg, data);
    }

    public static ResponseResult ok() {
        return new ResponseResult(NONE_STRING);
    }

    public static ResponseResult errorMsg(String msg) {
        return new ResponseResult(500, msg, NONE_STRING);
    }

    public static ResponseResult errorMap(Object data) {
        return new ResponseResult(501, ERROR, data);
    }

    public static ResponseResult errorTokenMsg(String msg) {
        return new ResponseResult(502, msg, NONE_STRING);
    }

    public static ResponseResult errorException(String msg) {
        return new ResponseResult(555, msg, NONE_STRING);
    }

    private ResponseResult() {
    }

    private ResponseResult(Integer status, String msg, Object data) {
        this.status = status;
        this.msg = msg;
        this.data = data;
    }

    private ResponseResult(Integer status, String msg, Object data, String ok) {
        this.status = status;
        this.msg = msg;
        this.data = data;
        this.ok = ok;
    }

    private ResponseResult(Object data) {
        this.status = 200;
        this.msg = "ok";
        this.data = data;
    }

    private Boolean isOk() {
        return this.status == 200;
    }

    public Integer getStatus() {
        return this.status;
    }

    private void setStatus(Integer status) {
        this.status = status;
    }

    public String getMsg() {
        return this.msg;
    }

    private void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return this.data;
    }

    private void setData(Object data) {
        this.data = data;
    }

    public String getOk() {
        return this.ok;
    }

    private void setOk(String ok) {
        this.ok = ok;
    }
}

