/*
 * Decompiled with CFR 0.152.
 */
package online.yangcloud.utils;

import cn.hutool.core.util.StrUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    private static final Logger logger = LoggerFactory.getLogger(IpUtil.class);
    private static final String ip = "127.0.0.1";
    private static final String unknown = "unknown";

    public static String getIpAddr(HttpServletRequest req) throws UnknownHostException {
        String ipAddress = req.getHeader("x-forwarded-for");
        if (StrUtil.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = req.getHeader("x-client-ip");
        }
        if (StrUtil.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = req.getHeader("client-ip");
        }
        if (StrUtil.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = req.getHeader("x-real-ip");
        }
        if (StrUtil.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = req.getHeader("Proxy-Client-IP");
        }
        if (StrUtil.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) {
            ipAddress = req.getHeader("WL-Proxy-Client-IP");
        }
        if ((StrUtil.isBlank((CharSequence)ipAddress) || ipAddress.length() == 0 || unknown.equalsIgnoreCase(ipAddress)) && ip.equals(ipAddress = req.getRemoteAddr())) {
            InetAddress inet;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                System.out.println("getIpAddr : " + e.getMessage());
                logger.info("ip addr error : {}", (Object)e.getMessage());
                throw e;
            }
            if (Objects.nonNull(inet)) {
                ipAddress = inet.getHostAddress();
            }
        }
        if (StrUtil.isNotBlank((CharSequence)ipAddress) && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }
}

