/*
 * Decompiled with CFR 0.152.
 */
package online.yuanpi.config;

import online.yuanpi.config.TaskConfiguration;
import online.yuanpi.entity.BaseTaskParam;
import org.springframework.data.redis.core.RedisTemplate;

public class SimpleRedisTaskConfiguration<T extends BaseTaskParam>
extends TaskConfiguration<T> {
    private static final String SCHEDULE_PARAM_KEY = "schedule_param_key";
    private final RedisTemplate<String, Object> redisTemplate;

    public SimpleRedisTaskConfiguration(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void saveTaskParam(T t) {
        this.nullParamObjectCheck(t);
        ((BaseTaskParam)t).requireParamCheck();
        this.redisTemplate.opsForHash().put((Object)SCHEDULE_PARAM_KEY, (Object)((BaseTaskParam)t).getTaskName(), t);
    }

    @Override
    public void updateTaskParam(T t) {
        this.nullParamObjectCheck(t);
        ((BaseTaskParam)t).requireTaskNameCheck();
        T sourceParam = this.getTaskParam(t);
        ((BaseTaskParam)t).fillNullValueFromSource((BaseTaskParam)sourceParam);
        this.redisTemplate.opsForHash().put((Object)SCHEDULE_PARAM_KEY, (Object)((BaseTaskParam)t).getTaskName(), t);
    }

    @Override
    public T getTaskParam(T t) {
        this.nullParamObjectCheck(t);
        ((BaseTaskParam)t).requireTaskNameCheck();
        return (T)((BaseTaskParam)this.redisTemplate.opsForHash().get((Object)SCHEDULE_PARAM_KEY, (Object)((BaseTaskParam)t).getTaskName()));
    }

    private void nullParamObjectCheck(T t) {
        if (t == null) {
            throw new NullPointerException("\u4efb\u52a1\u914d\u7f6e\u5c5e\u6027\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }
}

