/*
 * Decompiled with CFR 0.152.
 */
package org.aaronhe.threetengson;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import org.aaronhe.threetengson.InstantConverter;
import org.aaronhe.threetengson.LocalDateConverter;
import org.aaronhe.threetengson.LocalDateTimeConverter;
import org.aaronhe.threetengson.LocalTimeConverter;
import org.aaronhe.threetengson.OffsetDateTimeConverter;
import org.aaronhe.threetengson.OffsetTimeConverter;
import org.aaronhe.threetengson.ZonedDateTimeConverter;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.ZonedDateTime;

public class ThreeTenGsonAdapter {
    private static final Type INSTANT_TYPE_TOKEN = new TypeToken<Instant>(){}.getType();
    private static final Type LOCAL_DATE_TYPE = new TypeToken<LocalDate>(){}.getType();
    private static final Type LOCAL_DATE_TIME_TYPE = new TypeToken<LocalDateTime>(){}.getType();
    private static final Type LOCAL_TIME_TYPE = new TypeToken<LocalTime>(){}.getType();
    private static final Type OFFSET_DATE_TIME_TYPE = new TypeToken<OffsetDateTime>(){}.getType();
    private static final Type OFFSET_TIME_TYPE = new TypeToken<OffsetTime>(){}.getType();
    private static final Type ZONED_DATE_TIME_TYPE = new TypeToken<ZonedDateTime>(){}.getType();

    private ThreeTenGsonAdapter() {
    }

    public static GsonBuilder registerInstant(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapter(INSTANT_TYPE_TOKEN, (Object)new InstantConverter());
    }

    public static GsonBuilder registerLocalDate(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapter(LOCAL_DATE_TYPE, (Object)new LocalDateConverter());
    }

    public static GsonBuilder registerLocalDateTime(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapter(LOCAL_DATE_TIME_TYPE, (Object)new LocalDateTimeConverter());
    }

    public static GsonBuilder registerLocalTime(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapter(LOCAL_TIME_TYPE, (Object)new LocalTimeConverter());
    }

    public static GsonBuilder registerOffsetDateTime(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapter(OFFSET_DATE_TIME_TYPE, (Object)new OffsetDateTimeConverter());
    }

    public static GsonBuilder registerOffsetTime(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapter(OFFSET_TIME_TYPE, (Object)new OffsetTimeConverter());
    }

    public static GsonBuilder registerZonedDateTime(GsonBuilder gsonBuilder) {
        return gsonBuilder.registerTypeAdapter(ZONED_DATE_TIME_TYPE, (Object)new ZonedDateTimeConverter());
    }

    public static GsonBuilder registerAll(GsonBuilder gsonBuilder) {
        ThreeTenGsonAdapter.registerInstant(gsonBuilder);
        ThreeTenGsonAdapter.registerLocalDate(gsonBuilder);
        ThreeTenGsonAdapter.registerLocalDateTime(gsonBuilder);
        ThreeTenGsonAdapter.registerLocalTime(gsonBuilder);
        ThreeTenGsonAdapter.registerLocalDate(gsonBuilder);
        ThreeTenGsonAdapter.registerOffsetDateTime(gsonBuilder);
        ThreeTenGsonAdapter.registerOffsetTime(gsonBuilder);
        ThreeTenGsonAdapter.registerZonedDateTime(gsonBuilder);
        return gsonBuilder;
    }
}

