/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo;

import java.io.IOException;
import org.accidia.echo.EchoContext;
import org.accidia.echo.resources.ProtoServerApplication;
import org.accidia.protoserver.misc.ProtoServerException;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoApplication {
    private static final Logger logger = LoggerFactory.getLogger(EchoApplication.class);
    private ProtoServerApplication protoServerApplication;

    public static void main(String[] agrs) throws ProtoServerException, IOException, ReflectiveOperationException {
        EchoApplication.printTheStuff();
        EchoApplication application = new EchoApplication();
        logger.info("*** initializing context...");
        application.initializeContext();
        logger.info("*** initializing http server...");
        application.initializeProtoServerApplication();
        logger.info("*** starting http server...");
        application.protoServerApplication.startServer();
        logger.info("*** wait on server...");
        application.protoServerApplication.joinOnServer();
        logger.info("*** imma go now... pooof!");
    }

    protected static void printTheStuff() {
        logger.info("  \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u250c\u2500    \u250c\u2500\u2510\u2554\u2550\u2557\u252c \u252c\u250c\u2500\u2510    \u2500\u2510\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500  ");
        logger.info("  \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2502     \u251c\u2524 \u2551  \u251c\u2500\u2524\u2502 \u2502     \u2502\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500  ");
        logger.info("  \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2514\u2500    \u2514\u2500\u2518\u255a\u2550\u255d\u2534 \u2534\u2514\u2500\u2518    \u2500\u2518\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500  ");
    }

    protected void initializeContext() throws IOException, ReflectiveOperationException {
        EchoContext.INSTANCE.init();
    }

    protected void initializeProtoServerApplication() {
        this.protoServerApplication = new ProtoServerApplication();
        this.protoServerApplication.getServer().setServer(new Server(new ExecutorThreadPool(EchoContext.INSTANCE.getExecutorService())));
    }
}

