/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.mysql.relational;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.accidia.echo.protos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlProtobufRowMapper {
    private static final Logger logger = LoggerFactory.getLogger(MySqlProtobufRowMapper.class);

    public Message mapResultSet(ResultSet resultSet, Message.Builder builder) throws SQLException {
        logger.debug("mapRow(resultSet,rowNum)");
        for (Descriptors.FieldDescriptor fieldDescriptor : builder.getDescriptorForType().getFields()) {
            Blob blob;
            int columnIndex;
            String fieldName = fieldDescriptor.getName().toUpperCase();
            try {
                columnIndex = resultSet.findColumn(fieldName);
            }
            catch (SQLException e) {
                continue;
            }
            if (fieldDescriptor.isRepeated()) {
                Protos.ListResult objectList;
                blob = resultSet.getBlob(columnIndex);
                if (blob == null) {
                    logger.debug("no value set for field {} -> moving on", (Object)fieldName);
                    continue;
                }
                try {
                    ByteString byteString = ByteString.readFrom(blob.getBinaryStream());
                    objectList = Protos.ListResult.parseFrom(byteString);
                }
                catch (IOException e) {
                    logger.warn("failed to read from byte input stream for field {} -> moving on", (Object)fieldName);
                    continue;
                }
                builder.setField(fieldDescriptor, objectList);
                continue;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.STRING) {
                String value = resultSet.getString(columnIndex);
                if (value == null) continue;
                builder.setField(fieldDescriptor, value);
                continue;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.INT) {
                builder.setField(fieldDescriptor, resultSet.getInt(columnIndex));
                continue;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.LONG) {
                builder.setField(fieldDescriptor, resultSet.getLong(columnIndex));
                continue;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.FLOAT) {
                builder.setField(fieldDescriptor, Float.valueOf(resultSet.getFloat(columnIndex)));
                continue;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.DOUBLE) {
                builder.setField(fieldDescriptor, resultSet.getDouble(columnIndex));
                continue;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.BOOLEAN) {
                builder.setField(fieldDescriptor, resultSet.getBoolean(columnIndex));
                continue;
            }
            if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.BYTE_STRING) {
                ByteString byteString;
                blob = resultSet.getBlob(columnIndex);
                if (blob == null) {
                    logger.debug("no value set for field {} -> moving on", (Object)fieldName);
                    continue;
                }
                try {
                    byteString = ByteString.readFrom(blob.getBinaryStream());
                }
                catch (IOException e) {
                    logger.warn("failed to read from byte input stream for field {} -> moving on", (Object)fieldName);
                    continue;
                }
                builder.setField(fieldDescriptor, byteString);
                continue;
            }
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
        }
        return builder.buildPartial();
    }
}

