/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.protoserver.providers;

import com.google.common.base.Charsets;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/json"})
public class JsonMessageListWriter
implements MessageBodyWriter<List<Message>> {
    private static final Logger logger = LoggerFactory.getLogger(JsonMessageListWriter.class);

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public long getSize(List<Message> messages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            return this.messageListToString(messages).length();
        }
        catch (IOException e) {
            logger.warn("exception caught while calculating message size: ", e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    public void writeTo(List<Message> messages, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException, WebApplicationException {
        outputStream.write(this.messageListToString(messages).getBytes(Charsets.UTF_8));
    }

    protected String messageListToString(List<Message> messages) throws IOException {
        if (messages == null || messages.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean first = true;
        for (Message message : messages) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(",");
            }
            JsonFormat.print(message, (Appendable)stringBuilder);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

