/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.protoserver.providers;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/json"})
public class JsonMessageReader<ProtobufType extends Message>
implements MessageBodyReader<ProtobufType> {
    private static final Logger logger = LoggerFactory.getLogger(JsonMessageReader.class);
    private final ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();

    @Override
    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE) && type.getClass().isAssignableFrom(Message.class) && type.getClass() != Message.class.getClass();
    }

    @Override
    public ProtobufType readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            Method newBuilder = type.getMethod("newBuilder", new Class[0]);
            GeneratedMessage.Builder builder = (GeneratedMessage.Builder)newBuilder.invoke((Object)type, new Object[0]);
            String data = CharStreams.toString(new InputStreamReader(entityStream, Charsets.UTF_8));
            JsonFormat.merge(data, this.extensionRegistry, (Message.Builder)builder);
            return (ProtobufType)builder.buildPartial();
        }
        catch (Exception e) {
            logger.warn("exception caught while reading message: ", e);
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

