/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jetty.servlet;

import java.net.URI;
import java.util.Map;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.uri.UriComponent;

public final class JettyWebContainerFactory {
    private JettyWebContainerFactory() {
    }

    public static Server create(String u) throws Exception {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return JettyWebContainerFactory.create(URI.create(u));
    }

    public static Server create(String u, Map<String, String> initParams) throws Exception {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return JettyWebContainerFactory.create(URI.create(u), initParams);
    }

    public static Server create(URI u) throws Exception {
        return JettyWebContainerFactory.create(u, ServletContainer.class);
    }

    public static Server create(URI u, Map<String, String> initParams) throws Exception {
        return JettyWebContainerFactory.create(u, ServletContainer.class, initParams);
    }

    public static Server create(String u, Class<? extends Servlet> c) throws Exception {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return JettyWebContainerFactory.create(URI.create(u), c);
    }

    public static Server create(String u, Class<? extends Servlet> c, Map<String, String> initParams) throws Exception {
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        return JettyWebContainerFactory.create(URI.create(u), c, initParams);
    }

    public static Server create(URI u, Class<? extends Servlet> c) throws Exception {
        return JettyWebContainerFactory.create(u, c, null);
    }

    public static Server create(URI u, Class<? extends Servlet> c, Map<String, String> initParams) throws Exception {
        return JettyWebContainerFactory.create(u, c, null, initParams, null);
    }

    private static Server create(URI u, Class<? extends Servlet> c, Servlet servlet, Map<String, String> initParams, Map<String, String> contextInitParams) throws Exception {
        ServletHolder holder;
        if (u == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        String path = u.getPath();
        if (path == null) {
            throw new IllegalArgumentException("The URI path, of the URI " + u + ", must be non-null");
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException("The URI path, of the URI " + u + ", must be present");
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("The URI path, of the URI " + u + ". must start with a '/'");
        }
        path = String.format("/%s", UriComponent.decodePath(u.getPath(), true).get(1).toString());
        WebAppContext context = new WebAppContext();
        context.setDisplayName("JettyContext");
        context.setContextPath(path);
        context.setConfigurations(new Configuration[]{new WebXmlConfiguration()});
        if (c != null) {
            holder = context.addServlet(c, "/*");
        } else {
            holder = new ServletHolder(servlet);
            context.addServlet(holder, "/*");
        }
        if (contextInitParams != null) {
            for (Map.Entry<String, String> e : contextInitParams.entrySet()) {
                context.setInitParameter(e.getKey(), e.getValue());
            }
        }
        if (initParams != null) {
            holder.setInitParameters(initParams);
        }
        Server server = JettyHttpContainerFactory.createServer(u, false);
        server.setHandler(context);
        server.start();
        return server;
    }

    public static Server create(URI u, Servlet servlet, Map<String, String> initParams, Map<String, String> contextInitParams) throws Exception {
        if (servlet == null) {
            throw new IllegalArgumentException("The servlet must not be null");
        }
        return JettyWebContainerFactory.create(u, null, servlet, initParams, contextInitParams);
    }
}

