/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.filtering;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Maps;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.jersey.message.filtering.SelectableScopeResolver;
import org.glassfish.jersey.message.filtering.spi.EntityGraph;
import org.glassfish.jersey.message.filtering.spi.ObjectGraph;
import org.glassfish.jersey.message.filtering.spi.ScopeProvider;

final class ObjectGraphImpl
implements ObjectGraph {
    private final Set<String> filteringScopes;
    private final Map<Class<?>, EntityGraph> classToGraph;
    private final EntityGraph graph;
    private Set<String> fields;
    private Map<String, ObjectGraph> subgraphs;

    ObjectGraphImpl(Map<Class<?>, EntityGraph> classToGraph, EntityGraph graph, Set<String> filteringScopes) {
        this.filteringScopes = filteringScopes;
        this.classToGraph = classToGraph;
        this.graph = graph;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.graph.getEntityClass();
    }

    @Override
    public Set<String> getFields() {
        return this.getFields(null);
    }

    @Override
    public Set<String> getFields(String parent) {
        Set<String> childFilteringscopes = this.getFilteringScopes(parent);
        if (this.fields == null) {
            this.fields = this.graph.getFields(Sets.union(childFilteringscopes, Collections.singleton(ScopeProvider.DEFAULT_SCOPE)));
        }
        return this.fields;
    }

    @Override
    public Map<String, ObjectGraph> getSubgraphs() {
        return this.getSubgraphs(null);
    }

    @Override
    public Map<String, ObjectGraph> getSubgraphs(String parent) {
        Set<String> childFilteringscopes = this.getFilteringScopes(parent);
        if (this.subgraphs == null) {
            Map<String, Class<?>> contextSubgraphs = this.graph.getSubgraphs(childFilteringscopes);
            contextSubgraphs.putAll(this.graph.getSubgraphs(ScopeProvider.DEFAULT_SCOPE));
            this.subgraphs = Maps.transformValues(contextSubgraphs, new Function<Class<?>, ObjectGraph>(){

                @Override
                public ObjectGraphImpl apply(Class<?> clazz) {
                    return new ObjectGraphImpl(ObjectGraphImpl.this.classToGraph, (EntityGraph)ObjectGraphImpl.this.classToGraph.get(clazz), ObjectGraphImpl.this.filteringScopes);
                }
            });
        }
        return this.subgraphs;
    }

    private Set<String> getFilteringScopes(String parent) {
        HashSet<String> childFilteringscopes = new HashSet();
        if (this.filteringScopes.contains(SelectableScopeResolver.DEFAULT_SCOPE) || parent == null) {
            childFilteringscopes = this.filteringScopes;
        } else {
            for (String filteringScope : this.filteringScopes) {
                Pattern p = Pattern.compile(SelectableScopeResolver.PREFIX + parent + "\\.(\\w+)(\\.\\w+)*$");
                Matcher m = p.matcher(filteringScope);
                if (m.matches()) {
                    childFilteringscopes.add(SelectableScopeResolver.PREFIX + m.group(1));
                    continue;
                }
                childFilteringscopes.add(filteringScope);
            }
        }
        return childFilteringscopes;
    }
}

