/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.monitoring;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import jersey.repackaged.com.google.common.collect.Lists;
import jersey.repackaged.com.google.common.collect.Queues;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.monitoring.MonitoringStatisticsProcessor;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.ExtendedMonitoringStatisticsListener;
import org.glassfish.jersey.server.monitoring.MonitoringStatisticsListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.glassfish.jersey.uri.UriTemplate;

public final class MonitoringEventListener
implements ApplicationEventListener {
    private static final Logger LOGGER = Logger.getLogger(MonitoringEventListener.class.getName());
    @Inject
    private ServiceLocator serviceLocator;
    private final Queue<ApplicationEvent> applicationEvents = Queues.newArrayBlockingQueue(20);
    private final Queue<RequestStats> requestQueuedItems = Queues.newArrayBlockingQueue(50000);
    private final Queue<Integer> responseStatuses = Queues.newArrayBlockingQueue(50000);
    private final Queue<RequestEvent> exceptionMapperEvents = Queues.newArrayBlockingQueue(50000);
    private volatile long applicationStartTime;
    private volatile MonitoringStatisticsProcessor monitoringStatisticsProcessor;

    @Override
    public ReqEventListener onRequest(RequestEvent requestEvent) {
        switch (requestEvent.getType()) {
            case START: {
                return new ReqEventListener();
            }
        }
        return null;
    }

    @Override
    public void onEvent(ApplicationEvent event) {
        long now = System.currentTimeMillis();
        ApplicationEvent.Type type = event.getType();
        switch (type) {
            case INITIALIZATION_START: {
                break;
            }
            case RELOAD_FINISHED: 
            case INITIALIZATION_FINISHED: {
                this.applicationStartTime = now;
                this.applicationEvents.add(event);
                this.monitoringStatisticsProcessor = new MonitoringStatisticsProcessor(this.serviceLocator, this);
                this.monitoringStatisticsProcessor.startMonitoringWorker();
                break;
            }
            case DESTROY_FINISHED: {
                this.applicationEvents.add(event);
                if (this.monitoringStatisticsProcessor != null) {
                    try {
                        this.monitoringStatisticsProcessor.shutDown();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new ProcessingException(LocalizationMessages.ERROR_MONITORING_SHUTDOWN_INTERRUPTED(), e);
                    }
                }
                List<MonitoringStatisticsListener> listeners = this.serviceLocator.getAllServices(MonitoringStatisticsListener.class, new Annotation[0]);
                for (MonitoringStatisticsListener listener : listeners) {
                    try {
                        if (!(listener instanceof ExtendedMonitoringStatisticsListener)) continue;
                        ((ExtendedMonitoringStatisticsListener)listener).onDestroy();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, LocalizationMessages.ERROR_MONITORING_STATISTICS_LISTENER_DESTROY(listener.getClass()), e);
                    }
                }
                break;
            }
        }
    }

    long getApplicationStartTime() {
        return this.applicationStartTime;
    }

    public Queue<ApplicationEvent> getApplicationEvents() {
        return this.applicationEvents;
    }

    Queue<RequestEvent> getExceptionMapperEvents() {
        return this.exceptionMapperEvents;
    }

    Queue<RequestStats> getRequestQueuedItems() {
        return this.requestQueuedItems;
    }

    Queue<Integer> getResponseStatuses() {
        return this.responseStatuses;
    }

    private class ReqEventListener
    implements RequestEventListener {
        private volatile long requestTimeStart = System.currentTimeMillis();
        private volatile long methodTimeStart;
        private volatile MethodStats methodStats;

        @Override
        public void onEvent(RequestEvent event) {
            long now = System.currentTimeMillis();
            switch (event.getType()) {
                case RESOURCE_METHOD_START: {
                    this.methodTimeStart = now;
                    break;
                }
                case RESOURCE_METHOD_FINISHED: {
                    ResourceMethod method = event.getUriInfo().getMatchedResourceMethod();
                    this.methodStats = new MethodStats(method, this.methodTimeStart, now - this.methodTimeStart);
                    break;
                }
                case EXCEPTION_MAPPING_FINISHED: {
                    MonitoringEventListener.this.exceptionMapperEvents.add(event);
                    break;
                }
                case FINISHED: {
                    if (event.isResponseWritten()) {
                        MonitoringEventListener.this.responseStatuses.add(event.getContainerResponse().getStatus());
                    }
                    StringBuilder sb = new StringBuilder();
                    List<UriTemplate> orderedTemplates = Lists.reverse(event.getUriInfo().getMatchedTemplates());
                    for (UriTemplate uriTemplate : orderedTemplates) {
                        sb.append(uriTemplate.getTemplate());
                        if (!uriTemplate.endsWithSlash()) {
                            sb.append("/");
                        }
                        sb.setLength(sb.length() - 1);
                    }
                    MonitoringEventListener.this.requestQueuedItems.add(new RequestStats(new TimeStats(this.requestTimeStart, now - this.requestTimeStart), this.methodStats, sb.toString()));
                }
            }
        }
    }

    class RequestStats {
        private final TimeStats requestStats;
        private final MethodStats methodStats;
        private final String requestUri;

        private RequestStats(TimeStats requestStats, MethodStats methodStats, String requestUri) {
            this.requestStats = requestStats;
            this.methodStats = methodStats;
            this.requestUri = requestUri;
        }

        TimeStats getRequestStats() {
            return this.requestStats;
        }

        MethodStats getMethodStats() {
            return this.methodStats;
        }

        String getRequestUri() {
            return this.requestUri;
        }
    }

    static class MethodStats
    extends TimeStats {
        private final ResourceMethod method;

        private MethodStats(ResourceMethod method, long startTime, long requestDuration) {
            super(startTime, requestDuration);
            this.method = method;
        }

        ResourceMethod getMethod() {
            return this.method;
        }
    }

    static class TimeStats {
        private final long duration;
        private final long startTime;

        private TimeStats(long startTime, long requestDuration) {
            this.duration = requestDuration;
            this.startTime = startTime;
        }

        long getDuration() {
            return this.duration;
        }

        long getStartTime() {
            return this.startTime;
        }
    }
}

