package org.accidia.echo.mysql.keyvalue;

import org.accidia.echo.dao.StorageInitFailed;
import org.accidia.echo.dao.AbstractStorageModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.accidia.echo.protos.Protos;

public class MySqlKeyValueModule extends AbstractStorageModule {
    private static final Logger logger = LoggerFactory.getLogger(MySqlKeyValueModule.class);

    @Override
    public void configureForDataSource(final Protos.DataSource dataSource) throws StorageInitFailed {
        logger.debug("configureForDataSource(id)");

        logger.info("configuring storage meta with name {}", dataSource.getName());
    }

    @Override
    protected Protos.DataSource.StorageType getStorageType() {
        return Protos.DataSource.StorageType.MYSQL_KEYVALUE;
    }
}
