/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.resources;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.accidia.echo.EchoContext;
import org.accidia.protoserver.misc.AsyncResponses;
import org.glassfish.jersey.server.ManagedAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/template/")
public class TemplateResource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long requestTimeoutInSeconds = EchoContext.INSTANCE.getConfiguration().getConfig().getLong("echo.timeout_in_seconds");

    @GET
    @Path(value="/{tenant}/{templateId}")
    @Produces(value={"application/x-protobuf;qs=0.5", "application/json"})
    @ManagedAsync
    public void getTemplate(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenant") String tenant, @PathParam(value="templateId") String templateId) {
        this.logger.debug("getTemplate()");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(templateId.trim()), "null/empty templateId");
        AsyncResponses.addTimeoutHandler(asyncResponse, this.requestTimeoutInSeconds, TimeUnit.SECONDS);
        AsyncResponses.addCompletionCallback(asyncResponse);
        this.doGetTemplate(asyncResponse, tenant, templateId);
    }

    protected void doGetTemplate(AsyncResponse asyncResponse, String tenant, String templateId) {
        asyncResponse.resume(Response.ok().entity("<testing>" + templateId + "</testing>").type("text/plain").build());
    }
}

