/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.protoserver.providers;

import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
public class JsonMessageWriter
implements MessageBodyWriter<Message> {
    @Override
    public long getSize(Message message, Class clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonFormat.printToString(message).length();
    }

    @Override
    public boolean isWriteable(Class clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public void writeTo(Message message, Class clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        outputStream.write(JsonFormat.printToString(message).getBytes());
    }
}

