package org.accidia.echo.resources;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey2.InstrumentedResourceMethodApplicationListener;
import org.accidia.echo.EchoContext;
import org.accidia.echo.Constants;
import org.accidia.echo.protoserver.AbstractBaseProtoServerApplication;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URI;

public class ProtoServerApplication extends AbstractBaseProtoServerApplication {
    private static final Logger logger = LoggerFactory.getLogger(ProtoServerApplication.class);

    @Override
    public ResourceConfig getResourceConfig() {
        logger.debug("getResourceConfig()");
        final ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register(new InstrumentedResourceMethodApplicationListener(EchoContext.INSTANCE.getInjector().getInstance(MetricRegistry.class)));
        resourceConfig.packages("org.accidia.echo.resources");
        return resourceConfig;
    }

    @Override
    public URI getBaseUri() {
        logger.debug("getBaseUri()");
        final URI baseUri = URI.create(EchoContext.INSTANCE
                .getConfiguration().getConfig().getString(Constants.CONFIG_KEY__BIND));
        logger.info("base uri for rest api: {}", baseUri.toString());
        return baseUri;
    }
}

