package org.accidia.echo.client.impl;

import com.google.common.net.HostAndPort;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.accidia.echo.client.IEchoClient;
import org.accidia.echo.protoserver.misc.MediaTypes;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import java.util.List;

public class EchoSyncClient implements IEchoClient {

    private final HostAndPort serverHostAndPort;
    private final String serverBaseUrl;
    private final Client client;

    public static EchoSyncClient newInstance(final HostAndPort serverHostAndPort) {
        // TODO validate
        return new EchoSyncClient(serverHostAndPort);
    }

    protected EchoSyncClient(final HostAndPort serverHostAndPort) {
        this.serverHostAndPort = serverHostAndPort;
        this.serverBaseUrl = "http://" + serverHostAndPort.toString() + "/v1/";
        this.client = ClientBuilder.newClient();
    }

    @Override
    public <ProtobufType extends Message> ProtobufType getObject(final String tenantName, final String key, final ProtobufType.Builder builder) {
        // TODO validate
        final byte[] buffer = this.client.target(this.serverBaseUrl)
                .path("object")
                .path(tenantName)
                .path(key)
                .request()
                .header("accept", MediaTypes.APPLICATION_PROTOBUF)
                .get(byte[].class);
        try {
            return (ProtobufType) builder.mergeFrom(buffer);
        } catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ProtobufType extends Message> List<ProtobufType> getList(final String tenantName, final String key, final ProtobufType.Builder builder) {
        return null;
    }
}
