package org.accidia.echo.mysql.relational;

import org.accidia.echo.dao.StorageInitFailed;
import org.accidia.echo.dao.AbstractStorageModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static org.accidia.echo.protos.Protos.DataSource;

public class MySqlRelationalModule extends AbstractStorageModule {
    private static final Logger logger = LoggerFactory.getLogger(MySqlRelationalModule.class);

    @Override
    public void configureForDataSource(final DataSource dataSource) throws StorageInitFailed {
        logger.debug("configureForDataSource(id)");

        logger.info("configuring storage meta with name {}", dataSource.getName());
    }

    @Override
    public DataSource.StorageType getStorageType() {
        return DataSource.StorageType.MYSQL;
    }
}
