package org.accidia.echo.redis;

import com.google.common.base.Strings;
import com.google.protobuf.Message;
import org.accidia.echo.dao.IProtobufDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.accidia.echo.protos.Protos.*;

import java.util.List;

import static com.google.common.base.Preconditions.checkArgument;

public class RedisProtobufDao implements IProtobufDao {
    private static final Logger logger = LoggerFactory.getLogger(RedisProtobufDao.class);

    private final Message messageDefaultInstance;
    private final RedisAccessor redisAccessor;

    public static RedisProtobufDao newInstance(final Message messageDefaultInstance, final DataSource dataSource) {
        // TODO validate
        return new RedisProtobufDao(messageDefaultInstance, dataSource);
    }

    protected RedisProtobufDao(final Message messageDefaultInstance, final DataSource dataSource) {
        this.redisAccessor = new RedisAccessor();
        this.messageDefaultInstance = messageDefaultInstance;
    }

    @Override
    public Message findByKey(final String key) {
        logger.debug("findByKey(key)");
        checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return doFindByKey(key);
    }

    @Override
    public Message findFieldsByKey(final String key, final List<String> fields) {
        logger.debug("findFieldsByKey(key,fields)");
        checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        // TODO
        return null;
    }

    @Override
    public List<String> findList(final String key, final int start, final int count) {
        logger.debug("findList(key,start,count,orderby)");
        return doFindList(key, start, count);
    }

    @Override
    public List<String> findAllList(String listKey) {
        return null;
    }

    @Override
    public List<Message> findListObjects(String listKey, int start, int count) {
        // TODO
        return null;
    }

    @Override
    public List<Message> findAllListObjects(String listKey) {
        return null;
    }

    @Override
    public List<Message> findOrderedListObjectsAscending(String listKey, int start, int count) {
        return null;
    }

    @Override
    public List<Message> findAllOrderedListObjectsAscending(String listKey) {
        return null;
    }

    @Override
    public List<Message> findOrderedListObjectsDescending(String listKey, int start, int count) {
        return null;
    }

    @Override
    public List<Message> findAllOrderedListObjectsDescending(String listKey) {
        return null;
    }

    @Override
    public List<String> findOrderedListAscending(String listKey, int start, int conut) {
        return null;
    }

    @Override
    public List<String> findAllOrderedListAscending(String listKey) {
        return null;
    }

    @Override
    public List<String> findOrderedListDescending(String listKey, int start, int conut) {
        return null;
    }

    @Override
    public List<String> findAllOrderedListDescending(String listKey) {
        return null;
    }

    @Override
    public void store(final String key, final Message object) {
        logger.debug("store(key,object)");
        checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        checkArgument(object != null, "null object");
        doStore(key, object);
    }

    @Override
    public void addToList(final String listKey, final String objectKey) {
        // TODO
    }

    @Override
    public void removeFromList(String listKey, String objectKey) {
        // TODO
    }

    @Override
    public void addToOrderedList(String listKey, String objectKey, long weight) {

    }

    @Override
    public void storeOrUpdate(final String key, final Message object) {
        // TODO
    }

    @Override
    public void archive(final String key) {
        // TODO
    }

    @Override
    public Message getMessageDefaultInstance() {
        return this.messageDefaultInstance;
    }

    protected Message doFindByKey(final String key) {
        // get jedis for redis holding the key
        // find in jedis
        return null;
    }

    protected List<String> doFindList(final String key, final int start, final int count) {
        return null;
    }

    protected void doDelete(final String key) {

    }

    protected void doStore(final String key, final Message object) {
        // TODO
    }

    protected void doStoreOrUpdate(final String key, final Message object) {
        // TODO
    }
}

