/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.protoserver;

import com.google.common.base.Preconditions;
import org.accidia.echo.protoserver.IProtoServerApplication;
import org.accidia.echo.protoserver.misc.ProtoServerException;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseProtoServerApplication
implements IProtoServerApplication {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ResourceConfig resourceConfig = this.getResourceConfig();
    private Server server = JettyHttpContainerFactory.createServer(this.getBaseUri(), this.resourceConfig, false);

    @Override
    public void startServer() throws ProtoServerException {
        Preconditions.checkState(this.server != null, "null server");
        this.doStartServer();
    }

    @Override
    public void joinOnServer() throws ProtoServerException {
        Preconditions.checkState(this.server != null, "null server");
        this.doJoinOnServer();
    }

    @Override
    public void stopServer() throws ProtoServerException {
        Preconditions.checkState(this.server != null, "null server");
        this.doStopServer();
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    protected void doStartServer() throws ProtoServerException {
        this.logger.info("starting protoserver server at {}", (Object)this.getBaseUri().toString());
        try {
            this.server.start();
        }
        catch (Exception e) {
            this.logger.error("exception caught at server.start -> rethrowing", e);
            throw new ProtoServerException(e);
        }
    }

    protected void doJoinOnServer() throws ProtoServerException {
        this.logger.info("joining on server");
        try {
            this.server.join();
        }
        catch (Exception e) {
            this.logger.error("exception caught at server.join -> rethrowing", e);
            throw new ProtoServerException(e);
        }
    }

    protected void doStopServer() throws ProtoServerException {
        this.logger.info("stopping server");
        try {
            this.server.getServer().stop();
            this.server.destroy();
        }
        catch (Exception e) {
            this.logger.error("exception caught at server.stop/destroy -> rethrowing", e);
            throw new ProtoServerException(e);
        }
    }
}

