/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.services.impl;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.protobuf.Message;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.services.IObjectsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectsService
implements IObjectsService {
    private static final Logger logger = LoggerFactory.getLogger(ObjectsService.class);
    private final ListeningExecutorService listeningExecutorService;
    private final IProtobufDao protobufDao;

    public ObjectsService(ListeningExecutorService listeningExecutorService, IProtobufDao protobufDao) {
        this.listeningExecutorService = listeningExecutorService;
        this.protobufDao = protobufDao;
    }

    @Override
    @Timed
    public ListenableFuture<Message> getObject(String key) {
        logger.debug("getObject(key)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return this.doGetObjectAsync(key);
    }

    @Override
    public ListenableFuture<List<String>> getObjectList(String listKey, int start, int count) {
        logger.debug("getObjects(start,count)");
        Preconditions.checkArgument(start >= 0, "invalid start");
        Preconditions.checkArgument(count >= -1, "invalid count");
        return this.doGetObjectList(listKey, start, count);
    }

    @Override
    public ListenableFuture<Map<String, Message>> getObjects(List<String> keysList) {
        logger.debug("getObjects(keys)");
        Preconditions.checkArgument(keysList != null && !keysList.isEmpty(), "null/empty keys");
        return this.doGetObjects(keysList);
    }

    @Override
    public ListenableFuture<Message> getPartialObject(String key, List<String> fields) {
        logger.debug("getPartialObject(key,fields)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        if (fields == null || fields.isEmpty()) {
            logger.debug("null or empty fields; returning the complete object");
            return this.doGetObjectAsync(key);
        }
        return this.doGetPartialObjectAsync(key, fields);
    }

    @Override
    public ListenableFuture<Map<String, Message>> getPartialObjects(List<String> keys, List<String> fields) {
        logger.debug("getPartialObjects(keys,fields)");
        Preconditions.checkArgument(keys != null && !keys.isEmpty(), "null/empty keys");
        Preconditions.checkArgument(fields != null && !fields.isEmpty(), "null/empty fields");
        if (fields == null || fields.isEmpty()) {
            logger.debug("null or empty fields; returning the complete object");
            return this.doGetObjects(keys);
        }
        return this.doGetPartialObjects(keys, fields);
    }

    @Override
    public ListenableFuture<Message> storeObject(String key, Message object) {
        logger.debug("storeObject(key,object)");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        Preconditions.checkArgument(object != null, "null object");
        return this.doStoreObjectAsync(key, object);
    }

    @Override
    public ListenableFuture<List<Message>> storeObjects(Map<String, Message> keysToObjectsMap) {
        logger.debug("storeObjects(keysToObjectsMap)");
        Preconditions.checkArgument(keysToObjectsMap != null && !keysToObjectsMap.isEmpty(), "null/empty keysToObjectsMap");
        return this.doStoreObjects(keysToObjectsMap);
    }

    protected ListenableFuture<Message> doGetObjectAsync(String key) {
        return this.listeningExecutorService.submit(() -> this.protobufDao.findByKey(key));
    }

    protected ListenableFuture<List<String>> doGetObjectList(String listKey, int start, int count) {
        return this.listeningExecutorService.submit(() -> {
            int theCount = count == -1 ? 100 : count;
            return this.protobufDao.findList(listKey, start, theCount);
        });
    }

    protected ListenableFuture<Map<String, Message>> doGetObjects(List<String> keys) {
        ArrayList<ListenableFuture<Map.Entry<String, Message>>> futures = new ArrayList<ListenableFuture<Map.Entry<String, Message>>>(keys.size());
        for (String key : keys) {
            futures.add(this.transformMessageToObjectResult(key, this.doGetObjectAsync(key)));
        }
        return this.transformObjectResultsToListResult(Futures.allAsList(futures));
    }

    protected ListenableFuture<Message> doGetPartialObjectAsync(String key, List<String> fields) {
        return this.listeningExecutorService.submit(() -> this.protobufDao.findFieldsByKey(key, fields));
    }

    protected ListenableFuture<Map<String, Message>> doGetPartialObjects(List<String> keys, List<String> fields) {
        ArrayList<ListenableFuture<Map.Entry<String, Message>>> futures = new ArrayList<ListenableFuture<Map.Entry<String, Message>>>(keys.size());
        for (String key : keys) {
            futures.add(this.transformMessageToObjectResult(key, this.getPartialObject(key, fields)));
        }
        return this.transformObjectResultsToListResult(Futures.allAsList(futures));
    }

    protected ListenableFuture<Message> doStoreObjectAsync(String key, Message object) {
        return this.listeningExecutorService.submit(() -> {
            this.doStoreObject(key, object);
            return null;
        });
    }

    protected void doStoreObject(String key, Message object) {
        try {
            this.protobufDao.store(key, object);
        }
        catch (RuntimeException e) {
            logger.warn("exception on storing object: ", e);
            throw e;
        }
    }

    protected ListenableFuture<List<Message>> doStoreObjects(Map<String, Message> keysToObjectsMap) {
        ArrayList<ListenableFuture<Message>> futures = new ArrayList<ListenableFuture<Message>>(keysToObjectsMap.size());
        for (Map.Entry<String, Message> objectEntry : keysToObjectsMap.entrySet()) {
            futures.add(this.doStoreObjectAsync(objectEntry.getKey(), objectEntry.getValue()));
        }
        return Futures.allAsList(futures);
    }

    private ListenableFuture<Map<String, Message>> transformObjectResultsToListResult(ListenableFuture<List<Map.Entry<String, Message>>> objectResults) {
        return Futures.transform(objectResults, input -> {
            HashMap result = new HashMap(input.size());
            for (Map.Entry entry : input) {
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        });
    }

    private ListenableFuture<Map.Entry<String, Message>> transformMessageToObjectResult(String key, ListenableFuture<Message> future) {
        return Futures.transform(future, object -> new AbstractMap.SimpleEntry<String, Message>(key, (Message)object));
    }
}

