/*
 * Decompiled with CFR 0.152.
 */
package org.accidia.echo.mysql.keyvalue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.accidia.echo.dao.IProtobufDao;
import org.accidia.echo.mysql.MySqlDataSource;
import org.accidia.echo.mysql.keyvalue.MySqlKeyValueProtobufRowMapper;
import org.accidia.echo.protos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class MySqlKeyValueProtobufDao
extends JdbcDaoSupport
implements IProtobufDao {
    private static final Logger logger = LoggerFactory.getLogger(MySqlKeyValueProtobufDao.class);
    private final Message messageDefaultInstance;
    private final MySqlKeyValueProtobufRowMapper mySqlProtobufRowMapper = new MySqlKeyValueProtobufRowMapper();
    private final RowMapper<Message> rowMapper = (resultSet, rowNum) -> this.mySqlProtobufRowMapper.mapResultSet(resultSet, this.getMessageBuilder());

    public static MySqlKeyValueProtobufDao newInstance(Message messageDefaultInstancee, Protos.DataSource dataSource) {
        try {
            return new MySqlKeyValueProtobufDao(messageDefaultInstancee, dataSource).createTablesIfNotExist();
        }
        catch (Descriptors.DescriptorValidationException | IOException | ReflectiveOperationException e) {
            logger.warn("failed to create new mysql protobuf dao instance:", e);
            throw new RuntimeException(e);
        }
    }

    protected MySqlKeyValueProtobufDao(Message messageDefaultInstance, Protos.DataSource dataSource) throws Descriptors.DescriptorValidationException, ReflectiveOperationException, IOException {
        logger.debug("MySqlProtobufDao()");
        this.messageDefaultInstance = messageDefaultInstance;
        this.setDataSource(MySqlDataSource.getInstance(dataSource).getConnectoinPoolDataSource());
    }

    @Override
    public Message findByKey(String key) {
        logger.debug("findByKey()");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return this.doFindByKey(key);
    }

    @Override
    public Message findFieldsByKey(String key, List<String> fieldsIgnored) {
        logger.debug("findFieldsByKey()");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        return this.doFindByKey(key);
    }

    @Override
    public List<String> findList(String listKey, int start, int count) {
        logger.debug("findList()");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(listKey), "null/empty listkey");
        Preconditions.checkArgument(start >= 0, "invalid start");
        Preconditions.checkArgument(count >= -1, "invalid count");
        return this.doFindList(listKey, start, count, " ORDER BY `TIMESTAMP` DESC ");
    }

    @Override
    public List<String> findAllList(String listKey) {
        return this.findList(listKey, 0, -1);
    }

    @Override
    public List<Message> findListObjects(String listKey, int start, int count) {
        logger.debug("findListObjects()");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(listKey), "null/empty listkey");
        Preconditions.checkArgument(start >= 0, "invalid start");
        Preconditions.checkArgument(count >= -1, "invalid count");
        return this.doFindListObjects(listKey, start, count, " ORDER BY `TIMESTAMP` DESC ");
    }

    @Override
    public List<Message> findAllListObjects(String listKey) {
        return this.findListObjects(listKey, 0, -1);
    }

    @Override
    public List<Message> findOrderedListObjectsAscending(String listKey, int start, int count) {
        return this.doFindListObjects(listKey, start, count, " ORDER BY `OBJECT_WEIGHT` ASC, `TIMESTAMP` DESC ");
    }

    @Override
    public List<Message> findAllOrderedListObjectsAscending(String listKey) {
        return this.findOrderedListObjectsAscending(listKey, 0, -1);
    }

    @Override
    public List<Message> findOrderedListObjectsDescending(String listKey, int start, int count) {
        return this.doFindListObjects(listKey, start, count, " ORDER BY `OBJECT_WEIGHT` DESC, `TIMESTAMP` DESC ");
    }

    @Override
    public List<Message> findAllOrderedListObjectsDescending(String listKey) {
        return this.findOrderedListObjectsDescending(listKey, 0, -1);
    }

    @Override
    public List<String> findOrderedListAscending(String listKey, int start, int count) {
        return this.doFindList(listKey, start, count, " ORDER BY `OBJECT_WEIGHT` ASC, `TIMESTAMP` DESC ");
    }

    @Override
    public List<String> findAllOrderedListAscending(String listKey) {
        return this.findOrderedListAscending(listKey, 0, -1);
    }

    @Override
    public List<String> findOrderedListDescending(String listKey, int start, int count) {
        return this.doFindList(listKey, start, count, " ORDER BY `OBJECT_WEIGHT` DESC, `TIMESTAMP` DESC ");
    }

    @Override
    public List<String> findAllOrderedListDescending(String listKey) {
        return this.findOrderedListDescending(listKey, 0, -1);
    }

    @Override
    public void store(String key, Message object) {
        logger.debug("store()");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        Preconditions.checkArgument(object != null, "null object");
        this.doStore(key, object, this.getObjectTableName());
    }

    @Override
    public void addToList(String listKey, String objectKey) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(listKey), "null/empty listKey");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(objectKey), "null/empty objectKey");
        this.doAddToList(listKey, objectKey);
    }

    @Override
    public void removeFromList(String listKey, String objectKey) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(listKey), "null/empty listKey");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(objectKey), "null/empty objectKey");
        this.doRemoveFromList(listKey, objectKey);
    }

    @Override
    public void addToOrderedList(String listKey, String objectKey, long weight) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(listKey), "null/empty listKey");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(objectKey), "null/empty objectKey");
        this.doAddToOrderedList(listKey, objectKey, weight);
    }

    @Override
    public void storeOrUpdate(String key, Message object) {
        this.store(key, object);
    }

    @Override
    public void archive(String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "null/empty key");
        this.doArchive(key);
    }

    @Override
    public Message getMessageDefaultInstance() {
        return this.messageDefaultInstance;
    }

    protected void doArchive(String key) {
        Message message = this.findByKey(key);
        Preconditions.checkArgument(message != null, "invalid message");
        this.doStore(key, message, this.getArchiveTableName());
        this.doDelete(key, this.getObjectTableName());
    }

    protected Message doFindByKey(String key) {
        String sql = "SELECT `KEY`,`VALUE` FROM `" + this.getObjectTableName() + "` WHERE `KEY` = ?";
        List<Message> messages = this.getJdbcTemplate().query(sql, this.rowMapper, key);
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        return messages.get(0);
    }

    protected void doStore(String key, Message object, String tableName) {
        String sql = "REPLACE INTO `" + tableName + "` SET `KEY` = ?, `VALUE` = ?";
        this.getJdbcTemplate().update(sql, key, object.toByteArray());
    }

    protected void doDelete(String key, String tableName) {
        String sql = "DELETE FROM `" + tableName + "` WHERE `KEY` = ?";
        this.getJdbcTemplate().update(sql, key);
    }

    protected List<String> doFindList(String listKey, int start, int count, String orderby) {
        String sql;
        StringBuilder sqlStringBuilder = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(listKey);
        sqlStringBuilder.append("SELECT `OBJECT_KEY` FROM `").append(this.getListTableName()).append("` WHERE `LIST_KEY` = ? ").append(orderby);
        if (start == 0 && count == -1) {
            sql = sqlStringBuilder.toString();
        } else {
            sqlStringBuilder.append("LIMIT ?, ?");
            parameters.add(start);
            parameters.add(count);
            sql = sqlStringBuilder.toString();
        }
        logger.debug("sql to run is {} and list key is {}", (Object)sql, (Object)listKey);
        List<String> objectKeys = this.getJdbcTemplate().query(sql, (rs, rowNum) -> rs.getString("OBJECT_KEY"), parameters.toArray());
        logger.debug("object keys: {}", (Object)objectKeys);
        return objectKeys != null ? objectKeys : Collections.emptyList();
    }

    protected List<Message> doFindListObjects(String listKey, int start, int count, String orderby) {
        List<Message> messageList;
        String sql;
        StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("SELECT `").append(this.getObjectTableName()).append("`.`VALUE`,`").append(this.getListTableName()).append("`.`TIMESTAMP`").append(" FROM `").append(this.getObjectTableName()).append("`,`").append(this.getListTableName()).append("` ").append(" WHERE ").append("`").append(this.getObjectTableName()).append("`").append(".`KEY` = `").append(this.getListTableName()).append("`.`OBJECT_KEY` ").append(" AND ").append("`").append(this.getListTableName()).append("`").append(".`LIST_KEY` = ? ").append(orderby);
        if (start == 0 && count == -1) {
            sql = sqlStringBuilder.toString();
            messageList = this.getJdbcTemplate().query(sql, this.rowMapper, listKey);
        } else {
            sqlStringBuilder.append("LIMIT ?, ?");
            sql = sqlStringBuilder.toString();
            messageList = this.getJdbcTemplate().query(sql, this.rowMapper, listKey, start, count);
        }
        logger.debug("sql to run is {}", (Object)sql);
        return messageList != null ? messageList : Collections.emptyList();
    }

    protected void doAddToList(String listKey, String objectKey) {
        StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("REPLACE INTO ").append("`").append(this.getListTableName()).append("`").append(" SET `LIST_KEY` = ?, `OBJECT_KEY` = ?");
        this.getJdbcTemplate().update(sqlStringBuilder.toString(), listKey, objectKey);
    }

    protected void doRemoveFromList(String listKey, String objectKey) {
        StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("DELETE FROM ").append("`").append(this.getListTableName()).append("`").append(" WHERE `LIST_KEY` = ? AND `OBJECT_KEY` = ?");
        this.getJdbcTemplate().update(sqlStringBuilder.toString(), listKey, objectKey);
    }

    protected void doAddToOrderedList(String listKey, String objectKey, long weight) {
        StringBuilder sqlStringBuilder = new StringBuilder();
        sqlStringBuilder.append("REPLACE INTO ").append("`").append(this.getListTableName()).append("`").append(" SET `LIST_KEY` = ?, `OBJECT_KEY` = ?, `OBJECT_WEIGHT` = ?");
        this.getJdbcTemplate().update(sqlStringBuilder.toString(), listKey, objectKey, weight);
    }

    protected MySqlKeyValueProtobufDao createTablesIfNotExist() {
        String sql = "CREATE TABLE IF NOT EXISTS `" + this.getObjectTableName() + "`( `KEY` VARCHAR(128) NOT NULL, " + " `VALUE` BLOB NOT NULL, " + " `TIMESTAMP` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, " + "  PRIMARY KEY (`KEY`) ) " + "  ENGINE=InnoDB DEFAULT CHARSET=utf8";
        String archiveSql = "CREATE TABLE IF NOT EXISTS `" + this.getArchiveTableName() + "` ( `KEY` varchar(128) NOT NULL, " + " `VALUE` BLOB NOT NULL, " + " `TIMESTAMP` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP," + "  PRIMARY KEY (`KEY`) ) " + "  ENGINE=InnoDB DEFAULT CHARSET=utf8";
        String listSql = "CREATE TABLE IF NOT EXISTS `" + this.getListTableName() + "` ( `LIST_KEY` VARCHAR(128) NOT NULL, " + " `OBJECT_KEY` VARCHAR(128) NOT NULL, " + " `OBJECT_WEIGHT` BIGINT, " + " `TIMESTAMP` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP, " + "  PRIMARY KEY (`LIST_KEY`,`OBJECT_KEY`) ) " + "  ENGINE=InnoDB DEFAULT CHARSET=utf8";
        this.getJdbcTemplate().update(sql);
        this.getJdbcTemplate().update(archiveSql);
        this.getJdbcTemplate().update(listSql);
        return this;
    }

    protected Message.Builder getMessageBuilder() {
        return this.messageDefaultInstance.newBuilderForType();
    }

    protected String getObjectTableName() {
        return this.getMessageDefaultInstance().getClass().getSimpleName().toUpperCase();
    }

    protected String getListTableName() {
        return this.getObjectTableName() + "_LIST";
    }

    protected String getArchiveTableName() {
        return this.getObjectTableName() + "_ARCHIVE";
    }
}

